package org.jsmth.jorm.jdbc;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author mason
 */
public class OrderedColumnRowMapper implements RowMapper<List<Object>> {

    @Override
    public List<Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        List<Object> ret = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; i++) {
            Object obj = getColumnValue(rs, i);
            ret.add(obj);
        }
        return ret;
    }

	/**
	 * Retrieve a JDBC object value for the specified column.
	*The default implementation uses the getObject method.
	 * Additionally, this implementation includes a "hack" to get around Oracle
	 * returning a non standard object for their TIMESTAMP datatype.
	 * @param rs is the ResultSet holding the data
	 * @param index is the column index
	 * @return 返回信息 the Object returned
	 * @see JdbcUtils#getResultSetValue
	 * @throws SQLException dd
	 */
	protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
		return JdbcUtils.getResultSetValue(rs, index);
	}
}
