package org.jsmth.jorm.jdbc;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * User: 马生录（mason
 * Date: 14-1-5
 * Time: 下午10:07
 */
public class ObjectRowMapper<T> implements RowMapper {

    private Class<T> cls;

    public ObjectRowMapper(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public Object mapRow(ResultSet rs, int num) throws SQLException {
        T t = null;
        try {
            // 获取对象中的所有字段
            Field[] fields = cls.getDeclaredFields();
            // 实例化
            t = cls.newInstance();
            for (Field f : fields) {
                //              if(f.isAnnotationPresent(NotPersistent.class)){
                //                  continue;
                //              }
                // 获取字段名称
                String fieldName = f.getName();
                if (StringUtils.isBlank(fieldName)) {
                    continue;
                }
                Object o = null;
                // 通过字段名称获取该字段的值（实体字段名称必须与数据库字段名称一致才可以）
                o = rs.getObject(fieldName);
                if (o == null) {
                    continue;
                }
                // 使用BeanUtils通过字段名将value设置到实体中
                BeanUtils.setProperty(t, fieldName, o);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }


}
