package org.jsmth.jorm.jdbc;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.jsmth.exception.SmthExceptionDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.jorm.query.*;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

import javax.sql.DataSource;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * User: 马生录（mason
 * Date: 12-2-9
 * Time: 下午10:06
 */
public class NewBaseJdbcDao extends JdbcTemplate {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected SQLExceptionTranslator exceptionTranslator;
    protected DataSource dataSource;
    protected Dialect dialect = new MySQL5Dialect();

    public NewBaseJdbcDao(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;

    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(String dialect) {
        this.dialect = DialectType.getHibernateDialect(DialectType.valueOf(dialect));
    }

    /**
     * 设置数据库方言
     *
     * @param dialect dd
     */
    public void setDialect(DialectType dialect) {
        this.dialect = DialectType.getHibernateDialect(dialect);
    }



//    insert
//    update
//    udpateColumn
//    clearColumn
//    deleteWhere
//    deleteById
//    deleteAll
//    findAll
//    findAllIds
//    findIdsByWhere
//    findModelsByWhere
//    findColumnsByWhere
//    findMutiColumnsByWhere
//    groupMutiColumnByWhere
//    pageFindModelByWhere
//    pageFindColumnByWhere
//    pageFindMutiColumnByWhere
//    getModelById
//    firstModelByWhere
//    lastModelByWhere
//    groupColumnByWhere
//     countByWhere
//     minByWhere
//     maxByWhere
//     sumByWhere
//    createTable
//    dropTable
//    createIndex
//    dropIndex

    //<editor-fold desc="insert">
    public <T> T insertQuery(InsertQuery query) {

        return null;
    }

    public <T> int insertQuerys(Collection<InsertQuery> querys) {
        return 0;
    }

    public <T> T insertModel(T model) {
        return null;
    }

    public <T> int insertModels(Collection<T> models) {
        return 0;
    }

    //</editor-fold>
    //<editor-fold desc="update">
    public <T> int udpateQuerys(Collection<UpdateQuery> querys) {
        return 0;
    }

    public <T> int udpateQuerys(UpdateQuery query) {
        return 0;
    }

    public <T> int udpateModelByWhere(T model, WhereQuery query) {
        return 0;
    }

    public <T> int udpateModels(Collection<T> models) {
        return 0;
    }

    public <C> int udpateColumnByWhere(C columnValue, WhereQuery query) {
        return 0;
    }

    public int udpateMutiColumn(Map<String, Object> columns, WhereQuery query) {
        return 0;
    }

    //</editor-fold>
    //<editor-fold desc="delete">
    public int deleteQuery(DeleteQuery query) {
        return 0;
    }

    public int deleteByWhere(WhereQuery query) {
        return 0;
    }

    //</editor-fold>
    //<editor-fold desc="get model">
    public <T> T getModelByWhere(WhereQuery query) {
        return null;
    }

    public <T> T firstModelByWhere(WhereQuery query) {
        return null;
    }

    public <T> T lastModelByWhere(WhereQuery query) {
        return null;
    }

    public <T, C> C getColumnByWhere(WhereQuery query) {
        return null;
    }

    public <T, C> C firstColumnByWhere(WhereQuery query) {
        return null;
    }

    public <T, C> C lastColumnByWhere(WhereQuery query) {
        return null;
    }

    //</editor-fold>
    //<editor-fold desc="find model">
    public <T> List<T> findModelsByWhere(WhereQuery query) {
        return null;
    }

    public <T, C> List<C> findColumnsByWhere(WhereQuery query) {
        return null;
    }

    public <T> List<Map<String, Object>> findMutiColumnsByWhere(WhereQuery query) {
        return null;
    }

    //</editor-fold>
    //<editor-fold desc="group model">
    public <T, C> C groupColumnByWhere(SqlQuery query) {

        return null;
    }

    public <T> Map<String, Object> groupMutiColumnByWhere(SqlQuery query) {
        return null;
    }
    //</editor-fold>
    //<editor-fold desc="table schema">

    //</editor-fold>
    //<editor-fold desc="index schema">

    //</editor-fold>

    //<editor-fold desc="common sql">
    public void executeDDL(String sql)  throws SmthDataAccessException  {
        try {
            this.execute(sql);
        }catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }
//    public int execute(String sql)  throws SmthDataAccessException {
//        try {
//            return this.queryForObject(sql,Integer.class);
//        }catch (DataAccessException ex){
//            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
//        }
//    }
    //</editor-fold>

    public synchronized SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            DataSource dataSource = getDataSource();
            if (dataSource != null) {
                this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dataSource);
            } else {
                this.exceptionTranslator = new SQLStateSQLExceptionTranslator();
            }
        }
        return this.exceptionTranslator;
    }
}
