package org.jsmth.jorm.jdbc;

import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.lang.enums.EnumUtils;
import org.jsmth.util.EnumUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author mason
 */
@SuppressWarnings({"unchecked"})
public class JPARowMapper<T> implements RowMapper<T> {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    static final Map<Class, JPARowMapper> caches = new ConcurrentHashMap<Class, JPARowMapper>();

    public static <E> JPARowMapper<E> forClass(Class<E> clazz) {
        JPARowMapper ret = caches.get(clazz);
        if (ret == null) {
            synchronized (caches) {
                ret = caches.get(clazz);
                if (ret == null) {
                    ret = new JPARowMapper<E>(clazz);
                    caches.put(clazz, ret);
                }
            }
        }
        return ret;
    }

    protected Table<T> table;

    public JPARowMapper(Class<T> clazz) {
        this.table = Table.getTable(clazz);
    }

    @SuppressWarnings({"unchecked"})
    @Override
    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        Object mappedObject = BeanUtils.instantiateClass(this.table.clazz);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(mappedObject);

        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();

        for (int index = 1; index <= columnCount; index++) {
            String columnName = JdbcUtils.lookupColumnName(rsmd, index).toLowerCase();
            Column col = table.getColumnByColumnName(columnName);
            if (col != null) {
                try {
                    //jdbc result
                    Object value = null;
                    try {
//                        System.out.println("------------------ ");
//                        System.out.println("field " + col.fieldName + ":" + col.fieldName + ":" + col.getField().getType());
//                        logger.debug("field " + col.fieldName + ":" + col.fieldName + ":" + col.getField().getType());
                        Object rsValue = JdbcUtils.getResultSetValue(rs, index);
                        if (rsValue == null) {
                            rsValue = "null";
                        }
//                        logger.debug("resultset " + rsValue.toString());
//                        System.out.println("resultset " + rsValue.toString());
//                        System.out.println("------------------ ");

                        if (col.getField().getType().isEnum()) {
                            boolean ordinal = false;
                            Enumerated[] enumeratedTypes = col.getField().getAnnotationsByType(Enumerated.class);
                            int ivalue =0;
                            if (enumeratedTypes != null && enumeratedTypes.length > 0) {
                                if (enumeratedTypes[0].value() == EnumType.ORDINAL) {
                                    ordinal = true;
                                    ivalue = Integer.valueOf(rsValue.toString());
                                }
                            }
                            Class<Enum> typeclass = (Class<Enum>) col.getField().getType();
                            Enum[] enumConstants = typeclass.getEnumConstants();
                            for (Enum enumConstant : enumConstants) {
                                if (ordinal) {
                                    if (enumConstant.ordinal() == ivalue) {
                                        value = enumConstant;
                                        break;
                                    }
                                } else {
                                    if (enumConstant.name().toLowerCase().equals(rsValue.toString().toLowerCase())) {
                                        value = enumConstant;
                                        break;
                                    }
//                                    if (enumConstant.name().endsWith(rsValue.toString())) {
//                                        value = enumConstant;
//                                        break;
//                                    }
                                }
                            }
                        } else {
                            try {
                                value = JdbcUtils.getResultSetValue(rs, index, col.getField().getType());
                            }
                            catch (Exception ex){
                                System.out.println(ex.getMessage());
                            }
                        }
                    } catch (Exception ex) {
                        logger.error("getResultSetValue", ex);
                        continue;
                    }
                    if (col.isEnumerate() && col.isUseOrdinal()) {
                        value = col.getEnumValues()[(Integer) value];
                    }
                    if (value != null) {
                        bw.setPropertyValue(col.getFieldName(), value);
                    }
                } catch (NotWritablePropertyException ex) {
                    throw new DataRetrievalFailureException(
                            "Unable to map column " + columnName + " to property " + col.getField(), ex);
                }
            } else {
                logger.debug("no mapped column for name[{}]", columnName);
            }
        }
        return (T) mappedObject;
    }

}
