package org.jsmth.jorm.jdbc;

import org.apache.commons.lang.Validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * User: mason
 * Date: 2010-8-17
 * Time: 15:34:16
 */
public class Index {

    String name;
    List<String> columns = new ArrayList<String>();
    boolean clustered = false;
    boolean unqiue = false;

    public Index() {
    }

    public Index(org.hibernate.annotations.Index index) {
        this.name = index.name();
        Validate.notEmpty(index.columnNames());
        this.columns = Arrays.asList(index.columnNames());
    }

    public Index(String name, String... columns) {
        Validate.notEmpty(columns);
        this.name = name;
        this.columns = Arrays.asList(columns);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getColumns() {
        return columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public boolean isClustered() {
        return clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public boolean isUnqiue() {
        return unqiue;
    }

    public void setUnqiue(boolean unqiue) {
        this.unqiue = unqiue;
    }
}
