package org.jsmth.jorm.jdbc;

/**
 * @author mason
 */
public enum DialectType {

    MySQL,
    MySQL5,
    MySQL5InnoDB,
    MySQLMyISAM,
    MySQLInnoDB,
    HSQL,
    H2,
    Oracle10g,
    Oracle9i,
    Derby,
    SQLServer,;

    /**
     * 根据本地方言，获得Hibernate中的方言对象
     * @param dialect d
     * @param <T> d
     * @return 返回信息
     */
    @SuppressWarnings({"unchecked"})
    public static <T extends org.hibernate.dialect.Dialect> T getHibernateDialect(DialectType dialect) {
        try {
            return (T) Class.forName("org.hibernate.dialect."+dialect.name() + "Dialect").newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获得Hibernate中的方言对象
     * @param dialect d
     * @return 返回信息
     */
    public static DialectType getDialect(org.hibernate.dialect.Dialect dialect) {
        String name = dialect.getClass().getSimpleName();
        name = name.substring(0,name.length()-7);
        return DialectType.valueOf(name);
    }

}
