package org.jsmth.jorm.jdbc;

import org.hibernate.dialect.MySQL5Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.page.CommonPage;
import org.jsmth.page.RollPage;
import org.jsmth.page.TailPage;
import org.jsmth.util.aaaa;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

import javax.sql.DataSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 功能：
 * 马生录(mason) on 2015/5/28.
 */
public class CommonJdbcDao extends SmthSimpleJdbcTemplate {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected SQLExceptionTranslator exceptionTranslator;
    protected DataSource dataSource;

    public CommonJdbcDao(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void executeDDL(String sql) throws SmthDataAccessException {
        this.execute(sql);
    }


    public synchronized SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            DataSource dataSource = getDataSource();
            if (dataSource != null) {
                this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dataSource);
            } else {
                this.exceptionTranslator = new SQLStateSQLExceptionTranslator();
            }
        }
        return this.exceptionTranslator;
    }


    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) {
        return new int[0];

    }
    public int[] batchUpdate(String sql, SqlParameterSource[] batchValues) {
        return new int[0];

    }
    }
