package org.jsmth.jorm.jdbc;

import java.util.Date;

/**
 * @author mason
 */
public enum ColumnType {

    Int(Integer.class, null, null),
    Long(Long.class, null, null),
    Float(Float.class, null, null),
    Double(Double.class, null, null),
    string(String.class, null, null),
    date(Date.class, null, null),
    Boolean(java.lang.Boolean.class, null, null),
    Enum(java.lang.Enum.class, null, null),
    Char(String.class, null, null),
    ;

    Class mappingClazz;
    Class sqlClazz;
    String columnDefinition;

    ColumnType(Class clazz, Class sqlClazz, String columnDefinition) {
        this.mappingClazz = clazz;
        this.sqlClazz = sqlClazz;
        this.columnDefinition = columnDefinition;
    }

    public Class getMappingClazz() {
        return mappingClazz;
    }

    public Class getSqlClazz() {
        return sqlClazz;
    }

    public String getColumnDefinition() {
        return columnDefinition;
    }
}
