package org.jsmth.jorm.jdbc;

import org.jsmth.data.schema.FieldEmbeddedSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * @author mason
 */
@SuppressWarnings({"NullArgumentToVariableArgMethod"})
public class Column {

    protected static Logger logger = LoggerFactory.getLogger(Column.class);

    Field field;
    String fieldName;
    String columnName;
    ColumnType type;
    Class keyClass;
    FieldEmbeddedSchema fieldEmbeddedSchema=null;

    javax.persistence.Column detail;

    boolean identifier = false;
    boolean idAutoIncrease = false;
    boolean idNumberType=false;

    boolean enumerate = false;
    boolean useOrdinal = false;
    Object[] enumValues;

    boolean embedded = false;
//    Field embeddedField;

    public Column(Field field,Class keyClass) {
        if(keyClass==null){
            logger.debug("column keyClass is null");
        }else{
//            logger.debug("column keyClass is "+keyClass.getName());
        }
        this.keyClass=keyClass;
        this.field = field;
        this.fieldName = field.getName();
        this.columnName = JPAHelper.getColumnName(field);
        this.type = JPAHelper.getFieldType(field);
        if(this.type==null && keyClass!=null){
            this.type = JPAHelper.getFieldType(keyClass);
        }

        this.identifier = JPAHelper.isIdField(field);
        if (this.identifier) {
            this.idAutoIncrease = JPAHelper.isIdAutoIncrease(field);
        }
        //idNumberType=JPAHelper.isNumberFieldType(keyClass);
        this.enumerate = field.getType().isEnum();
        if (this.enumerate) {
            this.useOrdinal = JPAHelper.isUseOrdinal(field);
            Class<?> enumclazz = field.getType();
            try {
                Method valuesMethod = enumclazz.getDeclaredMethod("values");
                enumValues = (Object[]) valuesMethod.invoke(null);
            } catch (Exception e) {
                throw new RuntimeException("Error while accessing enum.values() for field[" + field + "]", e);
            }
        }
    }

//    public boolean isIdNumberType() {
//        return idNumberType;
//    }

    public Field getField() {
        return field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ColumnType getType() {
        return type;
    }

    public void setType(ColumnType type) {
        this.type = type;
    }

    public javax.persistence.Column getDetail() {
        return detail;
    }

    public void setDetail(javax.persistence.Column detail) {
        this.detail = detail;
    }

    public boolean isIdentifier() {
        return identifier;
    }

    public void setIdentifier(boolean identifier) {
        this.identifier = identifier;
    }

    public boolean isIdAutoIncrease() {
        return idAutoIncrease;
    }

    public void setIdAutoIncrease(boolean idAutoIncrease) {
        this.idAutoIncrease = idAutoIncrease;
    }

    public boolean isEnumerate() {
        return enumerate;
    }

    public void setEnumerate(boolean enumerate) {
        this.enumerate = enumerate;
    }

    public boolean isUseOrdinal() {
        return useOrdinal;
    }

    public void setUseOrdinal(boolean useOrdinal) {
        this.useOrdinal = useOrdinal;
    }

    public Object[] getEnumValues() {
        return enumValues;
    }

    public boolean isEmbedded() {
        return embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    //    public Field getEmbeddedField() {
//        return embeddedField;
//    }

//    public void setEmbeddedField(Field embeddedField) {
//        this.embeddedField = embeddedField;
//    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("Column");
        sb.append("{field=").append(field);
        sb.append(", fieldName='").append(fieldName).append('\'');
        sb.append(", columnName='").append(columnName).append('\'');
        sb.append(", type=").append(type);
//        sb.append(", embeddedField=").append(embeddedField);
        sb.append('}');
        return sb.toString();
    }

    public FieldEmbeddedSchema getFieldEmbeddedSchema() {
        return fieldEmbeddedSchema;
    }

    public void setFieldEmbeddedSchema(FieldEmbeddedSchema fieldEmbeddedSchema) {
        this.fieldEmbeddedSchema = fieldEmbeddedSchema;
    }

    public Class getKeyClass() {
        return keyClass;
    }

    public void setKeyClass(Class keyClass) {
        this.keyClass = keyClass;
    }
}
