package org.jsmth.jorm.iterator;

import org.apache.commons.lang.Validate;
import org.jsmth.jorm.jdbc.ColumnType;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.jorm.jdbc.Table;

import java.util.ArrayList;
import java.util.List;

/**
 * 适用于迭代获得int型自增id的表。
 * User: mason
 * Date: 2010-2-5
 * Time: 14:35:27
 */
public class IntIncreasedEntityBatchIterator<MODEL extends Identifier> extends EntityBatchIterator<Integer, MODEL> {

    int maxId = -1;
    int currentId = 1;//自增id都是从1开始

    public IntIncreasedEntityBatchIterator(Class<MODEL> entityClazz, JdbcDao jdbcDao, int pageSize) {
        super(Integer.class, entityClazz, jdbcDao, pageSize);
    }

    public IntIncreasedEntityBatchIterator(Class<MODEL> entityClazz, JdbcDao jdbcDao, int currentId, int pageSize) {
        super(Integer.class, entityClazz, jdbcDao, pageSize);
        this.currentId = currentId;
    }

    public int getMaxId() {
        if (this.maxId == -1) {
            this.maxId = (int) jdbcDao.maxId(entityClazz, "1=1");
        }
        return this.maxId;
    }

    @Override
    public boolean hasNext() {
        return currentId < getMaxId();
    }

    @Override
    protected void validKeyClass(Class<Integer> keyClazz) {
    }

    @Override
    protected void validEntityClass(Class<MODEL> entityClazz) {
        Table<MODEL> table = Table.getTable(entityClazz);
        Validate.isTrue(table.getIdColumn().isIdAutoIncrease(), String.format("class [%s] must be auto increase entity", entityClazz));
        Validate.isTrue(table.getIdColumn().getType() == ColumnType.Int, String.format("class [%s] primary key must be integer.", entityClazz));
    }

    @Override
    protected List<Integer> getItemKeys(int pageNumber) {
        List<Integer> ids = new ArrayList<Integer>();

        int start = currentId;
        int end = currentId + getPageSize();
        for (int i = start; i < end; i++) {
            ids.add(i);
        }
        this.currentId = currentId + getPageSize();
        return ids;
    }

    @Override
    public int getTotalItemsCount() {
        return getMaxId();
    }
}
