package org.jsmth.jorm.iterator;

import org.apache.commons.lang.Validate;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.jorm.jdbc.SQLHelper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-7-6
 * Time: 下午6:59
 */
public class ColumnValueEntituyBatchIterator<KEY extends Serializable, COLUMN extends Serializable, MODEL extends Identifier<KEY>>  implements Iterator<List<MODEL>> {

    protected int index = -1;
    protected COLUMN currentColumn;
    protected List<COLUMN> allColumns;
    protected Class<COLUMN> columnClazz;
    protected Class<MODEL> entityClazz;
    protected Class<KEY> keyClazz;
    protected String columnName;
    protected JdbcDao jdbcDao;

    protected String where = "1=1 ";
    protected Object[] params;

    public ColumnValueEntituyBatchIterator(Class<COLUMN> columnClazz, Class<KEY> keyClazz, Class<MODEL> clazz, JdbcDao jdbcDao, String columnName, String where, Object... params) {
        this.keyClazz = keyClazz;
        this.entityClazz = clazz;
        this.jdbcDao = jdbcDao;
        this.columnName = columnName;
        this.where = where;
        this.params = params;
        this.columnClazz = columnClazz;

        Validate.notEmpty(columnName, "columnName can not be empty");
        Validate.notEmpty(where, "query string can not be empty, use 1=1 instead");
    }

    protected List<COLUMN> getAllColumns() {
        if (allColumns == null) {
            allColumns = jdbcDao.findColumn(entityClazz, columnClazz, columnName, where+" group by " + columnName,params);
        }
        return allColumns;
    }

    public int getIndex() {
        if (index == -1) {
            if (hasNext())
                index = 0;
        }
        return index;
    }

    @Override
    public boolean hasNext() {
        return index < getAllColumns().size();
    }

    @Override
    public List<MODEL> next() {
        COLUMN column = allColumns.get(getIndex());
        StringBuilder sql = new StringBuilder(where);
        List sqlParams = new ArrayList();
        for (Object param : params) {
            sqlParams.add(param);
        }
        SQLHelper.appendEqual(sql, sqlParams, columnName, column);
        String where = sql.toString();
        index++;
        return jdbcDao.find(entityClazz, where, sqlParams.toArray());
    }


    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
