package org.jsmth.jorm.domain.extension;

import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.exception.SmthExceptionDict;
import org.jsmth.util.ExponentNumberUtil;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 功能：有效时间扩展
 * 马生录(mason) on 2015/10/20.
 */
@SuppressWarnings({"unchecked"})
@MappedSuperclass
public class ValidityDateTimeExtension implements Serializable, Cloneable {

    //<editor-fold desc="static">
    public static final int DEFAULT_EVERY = 0;  //每年、月、日、全周

    // 0 1 2 3 4  5  6  7   8   9   10   11   12   13   14 15 16 17 18
    // 1 2 4 8 16 32 64 128 256 512 1024 2048 4096
    //<editor-fold desc="Static">
    // 0 1 2 3 4  5  6  7   8   9   10   11   12   13   14 15 16 17 18
    // 1 2 4 8 16 32 64 128 256 512 1024 2048 4096

    public static final int SIV_0=1;
    public static final int SIV_1=2;
    public static final int SIV_2=4;
    public static final int SIV_3=8;
    public static final int SIV_4=16;
    public static final int SIV_5=32;
    public static final int SIV_6=64;
    public static final int SIV_7=128;
    public static final int SIV_8=256;
    public static final int SIV_9=512;
    public static final int SIV_10=1024;
    public static final int SIV_11=2048;
    public static final int SIV_12=4096;
    public static final int SIV_13=8192;
    public static final int SIV_14=16384;
    public static final int SIV_15=32768;
    public static final int SIV_16=65536;
    public static final int SIV_17=131072;
    public static final int SIV_18=262144;
    public static final int SIV_19=524288;
    public static final int SIV_20=1048576;
    public static final int SIV_21=2097152;
    public static final int SIV_22=4194304;
    public static final int SIV_23=8388608;
    public static final int SIV_24=16777216;
    public static final int SIV_25=33554432;
    public static final int SIV_26=67108864;
    public static final int SIV_27=134217728;
    public static final int SIV_28=268435456;
    public static final int SIV_29=536870912;
    public static final int SIV_30=1073741824;

    public static final int SVV_1=SIV_0;
    public static final int SVV_2=SIV_1;
    public static final int SVV_3=SIV_2;
    public static final int SVV_4=SIV_3;
    public static final int SVV_5=SIV_4;
    public static final int SVV_6=SIV_5;
    public static final int SVV_7=SIV_6;
    public static final int SVV_8=SIV_7;
    public static final int SVV_9=SIV_8;
    public static final int SVV_10=SIV_9;
    public static final int SVV_11=SIV_10;
    public static final int SVV_12=SIV_11;
    public static final int SVV_13=SIV_12;
    public static final int SVV_14=SIV_13;
    public static final int SVV_15=SIV_14;
    public static final int SVV_16=SIV_15;
    public static final int SVV_17=SIV_16;
    public static final int SVV_18=SIV_17;
    public static final int SVV_19=SIV_18;
    public static final int SVV_20=SIV_19;
    public static final int SVV_21=SIV_20;
    public static final int SVV_22=SIV_21;
    public static final int SVV_23=SIV_22;
    public static final int SVV_24=SIV_23;
    public static final int SVV_25=SIV_24;
    public static final int SVV_26=SIV_25;
    public static final int SVV_27=SIV_26;
    public static final int SVV_28=SIV_27;
    public static final int SVV_29=SIV_28;
    public static final int SVV_30=SIV_29;
    public static final int SVV_31=SIV_30;
    //</editor-fold>

    //最大月几在每年
    public static final int V_MONTH_MAX=SVV_12;//12;
    //第一季度
    public static final int V_MONTH_QUARTER_ONE=SVV_1+SVV_2+SVV_3;//1+2+3;
    //第二季度
    public static final int V_MONTH_QUARTER_TWO=SVV_1+SVV_2+SVV_3;//4+5+6;
    //第三季度
    public static final int V_MONTH_QUARTER_THREE=SVV_7+SVV_8+SVV_9;//7+8+9;
    //第四季度
    public static final int V_MONTH_QUARTER_FOUE=SVV_10+SVV_11+SVV_12;//10+11+12;
    //第三季度
    public static final int V_MONTH_QUARTER_FIRST_HALF =V_MONTH_QUARTER_ONE+V_MONTH_QUARTER_TWO;
    //第四季度
    public static final int V_MONTH_QUARTER_SECOND_HALF=V_MONTH_QUARTER_THREE+V_MONTH_QUARTER_FOUE;

    //最大周几在每周
    public static final int V_WEEK_MAX=SVV_7;//7;
    //一周单数
    public static final int V_WEEK_ODD=SVV_1+SVV_3+SVV_5+SVV_7;//1+3+5+7;
    //一周双数
    public static final int V_WEEK_EVEN=SVV_2+SVV_4+SVV_6+SVV_8;//2+4+6+8;
    //周末
    public static final int V_WEEK_WEEKEND=SVV_6+SVV_7;//6+7;
    //上班
    public static final int V_WEEK_WORK=SVV_1+SVV_2+SVV_3+SVV_4+SVV_5;//1+2+3+4+5;

    //最大日在每月
    public static final int V_DAY_MAX=SVV_31;//31;
    //月初
    public static final int V_DAY_FIRST=SVV_1;
    //月中
    public static final int V_DAY_CENTER=SVV_15;
    //奇数
    public static final int V_DAY_ODD=SVV_1+SVV_3+SVV_5+SVV_7+SVV_9+SVV_11+SVV_13+SVV_15+SVV_17+SVV_19+SVV_21+SVV_23+SVV_25+SVV_27+SVV_29+SVV_31;//1+3+5+7+9+11+13+15+17+19+21+23+25+27+29+31;
    //偶数
    public static final int V_DAY_EVEN=SVV_2+SVV_4+SVV_6+SVV_8+SVV_10+SVV_12+SVV_14+SVV_16+SVV_18+SVV_20+SVV_22+SVV_24+SVV_26+SVV_28+SVV_30;//2+4+6+8+10+12+14+16+18+20+22+24+26+28+30;

    //最大小时在每天
    public static final int V_HOUR_MAX=SVV_24;
    //偶数
    public static final int V_HOUR_ODD=SVV_1+SVV_3+SVV_5+SVV_7+SVV_9+SVV_11+SVV_13+SVV_15+SVV_17+SVV_19+SVV_21+SVV_23;
    //偶数
    public static final int V_HOUR_EVEN=SVV_2+SVV_4+SVV_6+SVV_8+SVV_10+SVV_12+SVV_14+SVV_16+SVV_18+SVV_20+SVV_22+SVV_24;
    /**
     * 凌晨(1：00—5：00)
     早上(5：00—8：00)
     上午(8：00—11：00)
     中午(11：00—13：00)
     下午(13：00—17：00)
     晚上(17：00—19：00)
     半夜(19：00—20：00)
     深夜(20：00—24：00)
     */
    //凌晨
    public static final int V_HOUR_BEFORE_DAWN=SVV_1+SVV_2+SVV_3+SVV_4;
    //早上
    public static final int V_HOUR_AFTERMORNING=SVV_5+SVV_6+SVV_7;
    //上午
    public static final int V_HOUR_MORNING=SVV_8+SVV_9+SVV_10;
    //中午
    public static final int V_HOUR_NOON=SVV_11+SVV_12;
    //下午
    public static final int V_HOUR_AFTERNOON=SVV_13+SVV_14+SVV_15+SVV_16;
    //晚上
    public static final int V_HOUR_NIGHT=SVV_17+SVV_18;
    //半夜
    public static final int V_HOUR_MIDDLE_NIGHTN=SVV_19;
    //深夜
    public static final int V_HOUR_LATE_NIGHT=SVV_20+SVV_21+SVV_22+SVV_23;

    //最大分钟在每小时
    public static final int V_MINUTE_MAX=60;
    //半小时
    public static final int V_MINUTE_HALF_HOUR=30;
    //一刻钟
    public static final int V_MINUTE_QUARTER_HOUR_AFTER=15;
    //后一刻钟
    public static final int V_MINUTE_QUARTER_HOUR_BEFOR=45;

    //最大秒数在每分钟
    public static final int V_SECOUND_MAX=60;
    public static final int V_SECOUND_OF_MINUTE=V_SECOUND_MAX;
    public static final int V_SECOUND_OF_HOUR=V_SECOUND_OF_MINUTE*V_MINUTE_MAX;
    public static final int V_SECOUND_OF_DAY=V_SECOUND_OF_HOUR*V_HOUR_MAX;

    //最大毫秒数在每秒
    public static final int V_MILLISECOUND_MAX=1000;
    public static final int V_MILLISECOUND_OF_SECOUND=V_MILLISECOUND_MAX;
    public static final int V_MILLISECOUND_OF_MINUTE=V_MILLISECOUND_OF_SECOUND*V_SECOUND_MAX;
    public static final int V_MILLISECOUND_OF_HOUR=V_MILLISECOUND_OF_MINUTE*V_MINUTE_MAX;
    public static final int V_MILLISECOUND_OF_DAY=V_MILLISECOUND_OF_HOUR*V_HOUR_MAX;
    //</editor-fold>

    int vyear = DEFAULT_EVERY;//年
    int vmonths = DEFAULT_EVERY;//月
    int vweeks = DEFAULT_EVERY;//周(1 2 4 8 16 32 64 代表周1 2 3 4 5 6 7)
    int vdays = DEFAULT_EVERY;//日（和周 2选1）
    int vstartMilliSecond = DEFAULT_EVERY;//开始时间  从1:00:00 开始的毫秒数
    int vendMilliSecond = DEFAULT_EVERY;//结束时间 从1:00:00 开始的毫秒数

    public ValidityDateTimeExtension() {
    }

    public ValidityDateTimeExtension(int vyear, int vmonths, int vweeks, int vdays, int vstartMilliSecond, int vendMilliSecond) {
        this.vyear = vyear;
        this.vmonths = vmonths;
        this.vweeks = vweeks;
        this.vdays = vdays;
        this.vstartMilliSecond = vstartMilliSecond;
        this.vendMilliSecond = vendMilliSecond;
    }

    /**
     * 返回月的集合
     *
     * @return 返回信息
     */
    public List<Integer> getMonths() {
        return getMonths(this.vmonths);
    }

    /**
     * 返回天的集合
     *
     * @return 返回信息
     */
    public List<Integer> getDays() {
        return getDays(this.vdays);
    }

    /**
     * 返回周几的集合
     *
     * @return 返回信息
     */
    public List<Integer> getWeekDays() {
        return getWeekDays(this.vweeks);
    }

    public boolean containsMonth(int month) {
        return containsMonth(this.vmonths, month);
    }

    public boolean containsWeek(int weekDay) {
        return containsWeek(this.vweeks, weekDay);
    }

    public boolean containsDay(int day) {
        return containsDay(this.vdays, day);
    }


    /**
     * 返回月的集合
     * @param months d
     * @return 返回信息
     */
    public static List<Integer> getMonths(int months) {
        return ExponentNumberUtil.getIndexValues(months);
    }

    /**
     * 返回天的集合
     * @param days d
     * @return 返回信息
     */
    public static List<Integer> getDays(int days) {
        return ExponentNumberUtil.getIndexValues(days);
    }

    /**
     * 返回周几的集合
     * @param weeks d
     * @return 返回信息
     */
    public static List<Integer> getWeekDays(int weeks) {
        return ExponentNumberUtil.getIndexValues(weeks);
    }

    public static boolean containsMonth(int months,int month) {
        return ExponentNumberUtil.containsIndexValue(months, month);
    }

    public static boolean containsWeek(int weekDays,int weekDay) {
        return ExponentNumberUtil.containsIndexValue(weekDays, weekDay);
    }

    public static boolean containsDay(int days, int day) {
        return ExponentNumberUtil.containsIndexValue(days, day);
    }

    public  void addMonth(int... months){
        vmonths=ExponentNumberUtil.addIndexValues(vmonths, months);
    }
    public  void addWeek(int... weeks){
        vweeks=ExponentNumberUtil.addIndexValues(vweeks, weeks);
    }
    public  void addDay(int... days){
        vdays=ExponentNumberUtil.addIndexValues(vdays, days);
    }
    //<editor-fold desc="ChcekDateTime">
    /**
     * 检查时间是否在有效期内
     *
     * @param time d
     * @return 返回信息
     */
    public boolean checkValidityDateTime(long time) {
        return checkValidityDateTime(false, time);
    }

    public boolean checkValidityDateTime(Date date) {
        return checkValidityDateTime(false, date);
    }

    public boolean checkValidityDateTime(boolean throwException, Date date) {
        return checkValidityDateTime(throwException, date.getTime());
    }

    /**
     * 检查时间是否在有效期内
     *
     * @param time s
     * @param throwException d
     * @return 返回信息
     */
    public boolean checkValidityDateTime(boolean throwException, long time) {
        if (!checkValidityDate(throwException, time)) {
            return false;
        }
        return checkValidityTime(throwException, time);
    }
    //</editor-fold>
    //<editor-fold desc="CheckDate">
    public boolean checkValidityDate(boolean throwException, long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int month = calendar.get(Calendar.MONTH) + 1;
        int week = calendar.get(Calendar.DAY_OF_WEEK);
        if (week == 1) {
            week = 8;
        }
        week = week - 1;
        int day = calendar.get(Calendar.DAY_OF_MONTH);
        return checkValidityDate(throwException, calendar.get(Calendar.YEAR), month, day, week);
    }
    public boolean checkValidityDate(boolean throwException, int year,int month,int week,int day) {
        if (vyear > 0 && vyear != year) {
            return throwException(throwException, SmthExceptionDict.ValidityDateTime_Year_Fail_Exception);
        }
        if (vmonths > 0) {
            if(!containsMonth(month)){
                return throwException(throwException, SmthExceptionDict.ValidityDateTime_Month_Fail_Exception);
            }
        }
        if (week > 0) {
            if(!containsWeek(week)){
                return throwException(throwException, SmthExceptionDict.ValidityDateTime_Week_Fail_Exception);
            }
        }
        if (day > 0) {
            if(!containsDay(day)){
                return throwException(throwException, SmthExceptionDict.ValidityDateTime_Day_Fail_Exception);
            }
        }
        return true;
    }
    //</editor-fold>
    //<editor-fold desc="CheckTime">
    public boolean checkValidityTime(boolean throwException, Date date) {
        return checkValidityTime(throwException,date.getTime());
    }
    public boolean checkValidityTime(boolean throwException, long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);

        return checkValidityTime(throwException,
                calendar.get(Calendar.HOUR),
                calendar.get(Calendar.MINUTE),
                calendar.get(Calendar.SECOND),
                calendar.get(Calendar.MILLISECOND));
    }

    public boolean checkValidityTime(boolean throwException, int hour, int minute, int second, int milliSecond) {
        int timeMilliSecond=hour*3600*1000+minute*60*1000+second*1000+milliSecond;
        if(vendMilliSecond==0){
            vendMilliSecond=V_MILLISECOUND_OF_DAY;
        }
        if(vstartMilliSecond<=vendMilliSecond) {
            //在同一天内
            if(vstartMilliSecond<=timeMilliSecond || timeMilliSecond<=vendMilliSecond){
                return true;
            }
        }else{
            //隔天
            int time24MilliSecond=24*3600*1000;
            if(vstartMilliSecond<=timeMilliSecond && timeMilliSecond<=time24MilliSecond){
                return true;
            }
            if(DEFAULT_EVERY<=timeMilliSecond && timeMilliSecond<=vendMilliSecond){
                return true;
            }
        }
        return throwException(throwException, SmthExceptionDict.ValidityDateTime_Time_Fail_Exception);
    }
    //</editor-fold>

    protected boolean throwException(boolean throwException, SmthExceptionDict code) {
        if (throwException) {
            throw new SmthDataAccessException(code);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ValidityDateTimeExtension{");
        builder.append("vyear=" + vyear);
        builder.append(", vmonths=" + vmonths+"(");
        for(int month:getMonths()){
            builder.append(", " + month);
        }
        builder.append(")");
        builder.append(", vweeks=" + vweeks+"(");
        for(int week:getWeekDays()){
            builder.append(", " + week);
        }
        builder.append(")");
        builder.append(", vdays=" + vdays+"(");
        for(int day:getDays()){
            builder.append(", " + day);
        }
        builder.append(")");
        builder.append(", vstartMilliSecond=" + getMilliSecondString(vstartMilliSecond));
        builder.append(", vendMilliSecond=" + getMilliSecondString(vendMilliSecond));
        builder.append('}');
        return builder.toString();
    }

    public String getMilliSecondString(int milliSecond){
        StringBuilder builder = new StringBuilder();
        int hour=milliSecond/3600000;
        int minute=milliSecond/60000;
        int second=milliSecond/1000;
        int misecond=milliSecond%1000;
        builder.append(milliSecond);
        builder.append("[");
        builder.append(hour);
        builder.append(":");
        builder.append(minute);
        builder.append(":");
        builder.append(second);
        builder.append(" ");
        builder.append(misecond);
        builder.append("]");
        return builder.toString();
    }
}
