package org.jsmth.jorm.domain.extension;

import com.google.gson.Gson;
//import org.codehaus.jackson.type.TypeReference;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * User: mason
 * Date: 2010-9-9
 * Time: 10:17:26
 */
@MappedSuperclass
public abstract class FieldMapContent<K,V> {

//    public static TypeReference<Map<Integer,Integer>> intintType = new TypeReference<Map<Integer,Integer>>() {};
//    public static TypeReference<Map<Integer,String>> intstringType = new TypeReference<Map<Integer,String>>() {};
//    public static TypeReference<Map<String,Integer>> stringintType = new TypeReference<Map<String,Integer>>() {};
//    public static TypeReference<Map<String,String>> stringstringType = new TypeReference<Map<String,String>>() {};

    String content;
    @Transient
    Map<K,V> items = new LinkedHashMap<K,V>(0);

    protected FieldMapContent() {
    }

    public void preInsert() {
        preUpdate();
    }

    public void preUpdate() {
        if (!items.isEmpty()) {
            Gson gson = new Gson();
            content= gson.toJson(items);
        }
    }

    public void postLoad() {
        if (content != null) {
            Gson gson = new Gson();
            items= gson.fromJson(content, items.getClass());
        }
    }

//    protected abstract TypeReference<Map<K,V>> getTypeReference();

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<K,V> getItems() {
        return items;
    }

    public void setItems(Map<K,V> items) {
        this.items = items;
    }

//    @Embeddable
//    public static class IntIntMap extends FieldMapContent<Integer,Integer> {
//
//        @Override
//        protected TypeReference<Map<Integer,Integer>> getTypeReference() {
//            return intintType;
//        }
//    }
//
//    @Embeddable
//    public static class IntStringMap extends FieldMapContent<Integer,String> {
//
//        @Override
//        protected TypeReference<Map<Integer,String>> getTypeReference() {
//            return intstringType;
//        }
//    }
//
//    @Embeddable
//    public static class StringIntMap extends FieldMapContent<String,Integer> {
//
//        @Override
//        protected TypeReference<Map<String,Integer>> getTypeReference() {
//            return stringintType;
//        }
//    }
//
//    @Embeddable
//    public static class StringStringMap extends FieldMapContent<String,String> {
//
//        @Override
//        protected TypeReference<Map<String,String>> getTypeReference() {
//            return stringstringType;
//        }
//    }

}
