package org.jsmth.jorm.domain.extension;

import org.jsmth.domain.Identifier;
import org.jsmth.util.PropertyUtils;

import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 2014/10/9
 * Time: 14:17
 */
public class ExtentModelProperty<KEY extends Serializable> implements Serializable {

    Identifier<KEY> instance;

    public ExtentModelProperty(Identifier<KEY> instance) {
        this.instance = instance;
    }

    //<editor-fold desc="property">
    public void addPropertyValue(String field, Object delta) {
        PropertyUtils.addPropertyValue(instance, field, delta);
    }

    public void addPropertyMaxValue(String field, Object maxValue) {
        PropertyUtils.addPropertyMaxValue(instance, field, maxValue);
    }

    public void addPropertyMaxValue(String field, Object delta, Object maxValue) {
        PropertyUtils.addPropertyMaxValue(instance, field, delta, maxValue);
    }

    public void subPropertyValue(String field, Object delta) {
        PropertyUtils.subPropertyValue(instance, field, delta);
    }

    public void subPropertyMinValue(String field, Object minValue) {
        PropertyUtils.subPropertyMinValue(instance, field, minValue);
    }

    public void subPropertyMinValue(String field, Object delta, Object minValue) {
        PropertyUtils.subPropertyMinValue(instance, field, delta, minValue);
    }

    public void increasePropertyMinMaxValue(String field, Object delta, Object minValue, Object maxValue) {
        PropertyUtils.increasePropertyMinMaxValue(instance, field, delta, minValue, maxValue);
    }

    public void increasePropertyValue(String field, Object delta) {
        PropertyUtils.increasePropertyValue(instance, field, delta);
    }
    //</editor-fold>

    //<editor-fold desc="mutiproperty">
    public void addPropertyValue(String... fields) {
        PropertyUtils.addPropertyValues(instance, fields);
    }

    public void addPropertyValue(Object delta, String... fields) {
        PropertyUtils.addPropertyValues(instance, delta, fields);
    }

    public void addPropertyMaxValue(Object maxValue, String... fields) {
        PropertyUtils.addPropertyMaxValues(instance, maxValue, fields);
    }

    public void addPropertyMaxValue(Object delta, Object maxValue, String... fields) {
        PropertyUtils.addPropertyMaxValues(instance, delta, maxValue, fields);
    }

    public void subPropertyValue(String... fields) {
        PropertyUtils.subPropertyValues(instance, fields);
    }

    public void subPropertyValue(Object delta, String... fields) {
        PropertyUtils.subPropertyValues(instance, delta, fields);
    }

    public void subPropertyMinValue(Object minValue, String... fields) {
        PropertyUtils.subPropertyMinValues(instance, minValue, fields);
    }

    public void subPropertyMinValue(Object delta, Object minValue, String... fields) {
        PropertyUtils.subPropertyMinValues(instance, delta, minValue, fields);
    }

    public void increasePropertyMinMaxValue(Object delta, Object minValue, Object maxValue, String... fields) {
        PropertyUtils.increasePropertyMinMaxValues(instance, delta, minValue, maxValue, fields);
    }

    public void increasePropertyValue(Object delta, String... fields) {
        PropertyUtils.increasePropertyValues(instance, delta, fields);
    }
    //</editor-fold>
}
