package org.jsmth.jorm.domain;

import com.google.gson.Gson;
//import org.codehaus.jackson.type.TypeReference;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * User: mason
 * Date: 2010-9-9
 * Time: 10:17:26
 */
@MappedSuperclass
public abstract class SetContent<T> {

//    public static TypeReference<Set<Integer>> intType = new TypeReference<Set<Integer>>() {
//    };
//    public static TypeReference<Set<String>> stringType = new TypeReference<Set<String>>() {
//    };

    String content;
    @Transient
    Set<T> items = new LinkedHashSet<T>(0);

    protected SetContent() {
    }

    public void preInsert() {
        preUpdate();
    }

    public void preUpdate() {
        if (!items.isEmpty()) {
            Gson gson = new Gson();
            content= gson.toJson(items);
        }
    }

    public void postLoad() {
        if (content != null) {
            Gson gson = new Gson();
            items= gson.fromJson(content, items.getClass());
        }
    }

//    protected abstract TypeReference<Set<T>> getTypeReference();

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }    

    public Set<T> getItems() {
        return items;
    }

    public void setItems(Set<T> items) {
        this.items = items;
    }

//    @Embeddable
//    public static class StringSet extends SetContent<String> {
//
//        @Override
//        protected TypeReference<Set<String>> getTypeReference() {
//            return stringType;
//        }
//    }
//
//    @Embeddable
//    public static class IntSet extends SetContent<Integer> {
//
//        @Override
//        protected TypeReference<Set<Integer>> getTypeReference() {
//            return intType;
//        }
//    }

}
