package org.jsmth.jorm.domain;

import com.google.gson.Gson;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.HashMap;
import java.util.Map;

/**
 * 用于只存放boolean, int, string, float的extension
 *
 * @author mason
 */
@MappedSuperclass
public class QuickExtension extends Extension {

    public QuickExtension() {
    }

    @Column(length = 1024)
    protected String extension_content;

    protected void validType(Object value) {
        if (!(value == null || value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Float)) {
            throw new IllegalArgumentException("QuickExtension can contains only [boolean, int, string, float]");
        }
    }

    @Override
    public Object put(String key, Object val) {
        validType(val);
        return super.put(key, val);
    }

    @Override
    protected String mapToText(Map<String, Object> extension) {
        if (extension == null || extension.isEmpty())
            return null;
        Gson gson = new Gson();
        return gson.toJson(extension);
    }

    @Override
    protected Map textToMap(String extension_content) {
        if (extension_content == null || extension_content.length() == 0)
            return new HashMap(0);
        Gson gson = new Gson();
        return gson.fromJson(extension_content, HashMap.class);
    }

    @Override
    public String getExtension_content() {
        return extension_content;
    }

    @Override
    public void setExtension_content(String extension_content) {
        this.extension_content = extension_content;
    }
}
