package org.jsmth.jorm.domain;

import com.google.gson.Gson;
import org.jsmth.jorm.domain.extension.ExtentModelProperty;
import org.jsmth.util.PropertyUtils;
import org.jsmth.domain.Identifier;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 主键为int的自增长id基础模型
 * 切记为自己实现的主键加上getter和setter方法
 *
 * @author mason
 */
@MappedSuperclass
public abstract class ProtoModel<KEY extends Serializable> extends BaseProtoModel<KEY> implements Identifier<KEY>, Serializable {

    @Transient
    protected ExtentModelProperty extentProperty;

    protected ProtoModel() {
        extentProperty = new ExtentModelProperty(this);
    }

    protected ProtoModel(ProtoModel<KEY> src) {
        this.setIdentifier(src.getIdentifier());
        extentProperty = new ExtentModelProperty(this);
    }

    public ExtentModelProperty extMethods() {
        return extentProperty;
    }

    @PrePersist
    @Override
    public void preInsert() {
    }

    @PreUpdate
    @Override
    public void preUpdate() {
    }

    @PostLoad
    @Override
    public void postLoad() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProtoModel baseModel = (ProtoModel) o;
        KEY id = getIdentifier();
        return id != null && id.equals(baseModel.getIdentifier());
    }

    @Override
    public int hashCode() {
        return getIdentifier().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass() + " id:" + getIdentifier();
    }

    public <T> void copyProperties(T orig) throws Exception {
        PropertyUtils.copyProperties(orig, this);
    }


    public String toJson() {
        Gson gson = new Gson();
        return gson.toJson(this);
    }
}
