package org.jsmth.jorm.domain;


import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jsmth.page.PageHelper;

import java.io.Serializable;
import java.util.*;

/**
 * key valueMap，但加入了一些跟index相关的操作。
 * 可用于 链接,链接描述，图片,图片描述 这样的数据结构
 *
 * @author mason
 */
public class Pairs extends LinkedHashMap<String, String> implements Serializable {

    public Pairs(int initialCapacity) {
        super(initialCapacity);
    }

    public Pairs() {
        super(0);
    }

    public Pairs(Map<? extends String, ? extends String> m) {
        super(m);
    }

    public void add(String key, String value) {
        if (!StringUtils.isBlank(key))
            this.put(key, value);
    }

    public void add(String key) {
        if (!StringUtils.isBlank(key))
            this.put(key, null);
    }

    /**
     * 获得key对应的索引号，性能不佳
     *
     * @param key d
     * @return 返回信息
     */
    public int indexOf(String key) {
        if (key == null || !this.containsKey(key)) return -1;
        int idx = 0;
        for (String s : this.keySet()) {
            if (s.equals(key)) return idx;
            idx++;
        }
        return idx;
    }

    /**
     * 获得所有pair对
     *
     * @return 返回信息
     */
    public Set<Map.Entry<String, String>> getPairs() {
        return this.entrySet();
    }

    /**
     * 根据索引值获得keyvalue对
     *
     * @param index d
     * @return 返回信息
     */
    public Map.Entry<String, String> getPair(int index) {
        Validate.isTrue(index >= 0);
        for (Map.Entry<String, String> stringStringEntry : this.entrySet()) {
            if (index == 0) return stringStringEntry;
            index--;
        }
        return null;
    }

    /**
     * 将pairs所有的key和value按照新给出的次序进行重排
     *
     * @param keys d
     * @param values d
     */
    public void resetAll(String[] keys, String[] values) {
        resetAll(keys, values, false);
    }

    public void resetAll(String[] keys, String[] values, boolean strict) {
        if (ArrayUtils.isEmpty(keys))
            return;

        this.clear();

        try {
            for (int i = 0; i < keys.length; i++) {
                String key = keys[i];
                if (!StringUtils.isBlank(key)) {
                    this.put(key, values[i]);
                }
            }
        } catch (Exception e) {
            if (strict)
                throw new IllegalArgumentException(e);
        }
    }

    /**
     * 根据给定key数组，对元素进行重排
     *
     * @param keys d
     */
    public void resort(String[] keys) {
        Map<String, String> a = new LinkedHashMap<String, String>();
        for (String key : keys) {
            if (!StringUtils.isBlank(key))
                a.put(key, this.get(key));
        }
        this.clear();
        this.putAll(a);
    }

    public void append(String[] keys) {
        Map<String, String> a = new LinkedHashMap<String, String>();
        for (String key : keys) {
            if (!StringUtils.isBlank(key))
                a.put(key, this.get(key));
        }
        this.putAll(a);
    }

    /**
     * 获得第一个key
     *
     * @return 返回信息
     */
    public String getFirstKey() {
        if (this.isEmpty())
            return null;
        else
            return this.keySet().iterator().next();
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keySet());
    }

    /**
     * 截断
     *
     * @param limit d
     * @param head d
     */
    public void truncate(int limit, boolean head) {
        PageHelper.limitMap(this, limit, head);
    }

    public List<String> getReversKey() {
        List<String> keys = new ArrayList<String>(this.keySet());
        Collections.reverse(keys);
        return keys;
    }

    public Pairs getReversPairs() {
        List<String> keys = new ArrayList<String>(this.keySet());
        Collections.reverse(keys);
        Pairs ret = new Pairs(keys.size());
        for (String s : keys) {
            ret.put(s, this.get(s));
        }
        return ret;
    }

}
