package org.jsmth.jorm.domain;

import com.google.gson.Gson;
//import org.codehaus.jackson.type.TypeReference;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-9-9
 * Time: 10:17:26
 */
@MappedSuperclass
public abstract class ListContent<T> {

//    public static TypeReference<List<Integer>> intType = new TypeReference<List<Integer>>() {
//    };
//    public static TypeReference<List<String>> stringType = new TypeReference<List<String>>() {
//    };

    String content;
    @Transient
    List<T> items = new ArrayList<T>(0);

    protected ListContent() {
    }

    public void preInsert() {
        preUpdate();
    }

    public void preUpdate() {
        if (!items.isEmpty()) {
            Gson gson = new Gson();
            content= gson.toJson(items);
        }
    }

    public void postLoad() {
        if (content != null) {
            Gson gson = new Gson();
            items= gson.fromJson(content, items.getClass());
        }
    }

//    protected abstract TypeReference<List<T>> getTypeReference();

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }    

    public List<T> getItems() {
        return items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

//    @Embeddable
//    public static class StringList extends ListContent<String> {
//
//        @Override
//        protected TypeReference<List<String>> getTypeReference() {
//            return stringType;
//        }
//    }
//
//    @Embeddable
//    public static class IntList extends ListContent<Integer> {
//
//        @Override
//        protected TypeReference<List<Integer>> getTypeReference() {
//            return intType;
//        }
//    }


}

