package org.jsmth.jorm.domain;


import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;

import javax.persistence.Embeddable;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import java.util.*;

/**
 * @author mason
 */
@Embeddable
@MappedSuperclass
public class FullExtension extends Extension {

    @Lob
    protected String extension_content;

    @Override
    protected String mapToText(Map<String, Object> extension) {
        if (extension == null || extension.isEmpty())
            return null;
        if (getMapStyle() == MAPSTYLE_JSON) {
            return mapToJson(extension);
        }
//        if (getMapStyle() == MAPSTYLE_XML) {
//            return mapToXml(treeExtension);
//        }
        throw new UnsupportedOperationException("MapStyle " + getMapStyle() + " not support.");
    }

    @Override
    protected Map textToMap(String extension_content) {
        if (extension_content == null || extension_content.length() == 0)
            return new HashMap(0);
        if (getMapStyle() == MAPSTYLE_JSON) {
            return jsonToMap(extension_content);
        }
//        if (getMapStyle() == MAPSTYLE_XML) {
//            return xmlToMap(extension_content);
//        }
        throw new UnsupportedOperationException("MapStyle " + getMapStyle() + " not support.");
    }

    protected String mapToJson(Map<String, Object> extension) {
        if (extension == null || extension.isEmpty())
            return null;
        GsonBuilder gb=new GsonBuilder();
        gb.setLongSerializationPolicy(LongSerializationPolicy.STRING);
        Gson gson=gb.create();
        return gson.toJson(extension);
    }

    protected Map jsonToMap(String extension_content) {
        if (extension_content == null || extension_content.length() == 0)
            return new HashMap(0);

        GsonBuilder gb=new GsonBuilder();
        gb.setLongSerializationPolicy(LongSerializationPolicy.STRING);
        Gson gson=gb.create();
        return gson.fromJson(extension_content,new LinkedHashMap<String,Object>().getClass());
    }


//    protected String mapToXml(Map<String, Object> treeExtension) {
//        if (treeExtension == null || treeExtension.isEmpty())
//            return null;
//        return Identifier.xstream.toXML(treeExtension);
//    }
//
//    protected Map xmlToMap(String extension_content) {
//        if (extension_content == null || extension_content.length() == 0)
//            return new HashMap(0);
//        return (Map) Identifier.xstream.fromXML(extension_content);
//    }

    @Override
    public String getExtension_content() {
        return extension_content;
    }

    @Override
    public void setExtension_content(String extension_content) {
        this.extension_content = extension_content;
    }


}
