package org.jsmth.jorm.domain;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.Map;
import java.util.List;

/**
 * @author mason
 */
public final class ExtensionHelper {

    public static String generateHTML(Class clazz) {
        return null;
    }

    public static String generateHTML(Field field) {
        String fieldName = field.getName();
        Class type = field.getType();
        StringBuilder sb = new StringBuilder();
        String s = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        String t = type.getSimpleName();
        Set<Class> genericClasses = new GenericClass(field.getGenericType()).getTypes();
        String generic = "<";
        for (Class genericClass : genericClasses) {
            generic += genericClass.getSimpleName() + ",";
        }
        generic = generic.substring(0, generic.length() - 1);
        if (generic.length() > 1) generic += ">";
        if (type == String.class || type.isAssignableFrom(Number.class)) {
            sb.append("<input type=\"text\" name=\"" + fieldName + "\" id=\"" + fieldName + "\">");
        }
//        else if (type == )
        return null;
    }

    public static String generateJavaSource(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        sb.append("//ext gs").append("\n");
        for (Field field : fields) {
            sb.append(generateKEY(field.getName())).append('\n');
        }
        sb.append("\r\n");
        for (Field field : fields) {
            sb.append(generateGetterAndSetter(field));
        }
        return sb.toString();
    }

    public static String generateKEY(String fieldName) {
        StringBuilder sb = new StringBuilder();
        String s = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());

        sb.append("public static final String ").append(s).append("= \"").append(s).append("\";");
        return sb.toString();
    }

    public static String generateGetterAndSetter(Field field) {
        String fieldName = field.getName();
        Class type = field.getType();

        StringBuilder sb = new StringBuilder();
        String s = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        String t = type.getSimpleName();
        Set<Class> genericClasses = new GenericClass(field.getGenericType()).getTypes();
        String generic = "<";
        for (Class genericClass : genericClasses) {
            generic += genericClass.getSimpleName() + ",";
        }
        generic = generic.substring(0, generic.length() - 1);
        if (generic.length() > 1) generic += ">";

        if (type == boolean.class || type == Boolean.class) {
            sb.append("public boolean is").append(s).append("(){\n"
                    + "return this.get(" + s + ", false, false);"
                    + "\n}\n");

            sb.append("public void set").append(s).append("(boolean flag){\n"
                    + "this.put(" + s + ", flag);"
                    + "\n}\n");
        } else if (type == String.class) {
            sb.append("public " + t + " get").append(s).append("(){\n"
                    + "return this.getStrProp(" + s + ");"
                    + "\n}\n");

            sb.append("public void set").append(s).append("(" + t + " flag){\n"
                    + "this.put(" + s + ", flag);"
                    + "\n}\n");

        } else if (Map.class.isAssignableFrom(type)) {
            sb.append("public " + t + generic + " get").append(s).append("(){\n"
                    + "return this.get(" + s + ", new LinkedHashMap" + generic + "(), true);"
                    + "\n}\n");

            sb.append("public void set").append(s).append("(" + t + generic + " map){\n"
                    + "this.put(" + s + ", map);"
                    + "\n}\n");

        } else if (List.class.isAssignableFrom(type)) {
            sb.append("public " + t + generic + " get").append(s).append("(){\n"
                    + "return this.get(" + s + ", new ArrayList" + generic + "(), true);"
                    + "\n}\n");

            sb.append("public void set").append(s).append("(" + t + generic + " list){\n"
                    + "this.put(" + s + ", list);"
                    + "\n}\n");

        } else if (Set.class.isAssignableFrom(type)) {
            sb.append("public " + t + generic + " get").append(s).append("(){\n"
                    + "return this.get(" + s + ", new LinkedHashSet" + generic + "(), true);"
                    + "\n}\n");

            sb.append("public void set").append(s).append("(" + t + generic + " set){\n"
                    + "this.put(" + s + ", set);"
                    + "\n}\n");
        } else {
            sb.append("public " + t + " get").append(s).append("(){\n"
                    + "return (" + t + ")this.get(" + s + ");"
                    + "\n}\n");

            sb.append("public void set").append(s).append("(" + t + " obj){\n"
                    + "this.put(" + s + ", obj);"
                    + "\n}\n");
        }
        return sb.toString();
    }
}
