package org.jsmth.jorm.domain;

import org.jsmth.domain.StringIdenticable;

import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;

/**
 * 为方便jdbc部分的使用，而构建的可扩展模型
 *
 * @author mason
 */
@SuppressWarnings({"unchecked"})
@MappedSuperclass
public abstract class ExtStringModel extends ExtModel<String> implements StringIdenticable {

    @Id
    @NotNull(message = "primary key must be set")
    protected String id;

    protected ExtStringModel() {
        super();
    }

    protected ExtStringModel(ExtModel<String> src) {
        super(src);
    }

    @Override
    public String getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(String id) {
        this.id = id;
    }

    @Override
    public boolean isIdModified() {
        return id != null;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isNewEntity() {
        return id == null;
    }
}
