package org.jsmth.jorm.domain;

import javax.persistence.Embedded;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 切记为自己实现的主键加上getter和setter方法
 * User: mason
 * Date: 2010-6-28
 * Time: 16:43:12
 */
@MappedSuperclass
public abstract class ExtModel<KEY extends Serializable> extends BaseModel<KEY> {


    @Embedded
    protected FullExtension extension = new FullExtension();

    protected ExtModel() {
    }

    protected ExtModel(ExtModel src) {
        super(src);
        extension.copyFrom(src.extension);
    }

    public int getMapStyle() {
        return extension.getMapStyle();
    }

    public void setMapStyle(int mapStyle) {
        extension.setMapStyle(mapStyle);
    }

    @Override
    public void postLoad() {
        extension.postLoad();
        super.postLoad();
    }

    @Override
    public void preInsert() {
        extension.preInsert();
        super.preInsert();
    }

    @Override
    public void preUpdate() {
        extension.preUpdate();
        super.preUpdate();
    }

    public FullExtension getExtension() {
        return extension;
    }

    public void setExtension(FullExtension extension) {
        this.extension = extension;
    }


    public String mapToText(Map<String, Object> extension) {
        return this.extension.mapToText(extension);
    }

    public <T> int putListItem(Class<T> classz, String key, T value, boolean override, int maxSize, int removeStyle) {
        return extension.putListItem(classz, key, value, override, maxSize, removeStyle);
    }

    public <K, V> int putMapItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, V value, boolean override, int maxSize, int removeStyle) {
        return extension.putMapItem(classKey, classValue, key, itemKey, value, override, maxSize, removeStyle);
    }

    protected <K, V> boolean containsMapListItem(Class<K> classKey, Class<V> classValue, String key, K itemKey) {
        return extension.containsMapListItem(classKey, classValue, key, itemKey);
    }

    protected <K, SK, V> int putMapMapItemItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, SK subItemKey, V value, boolean override) {
        return extension.putMapMapItemItem(classKey, classSubKey, classValue, key, itemKey, subItemKey, value, override);
    }

    protected <K, V> boolean containsMapItem(Class<K> classKey, Class<V> classValue, String key, K itemKey) {
        return extension.containsMapItem(classKey, classValue, key, itemKey);
    }

    protected void removeValueStringListItem(String key, int index) {
        extension.removeValueStringListItem(key, index);
    }

    protected Integer getValueIntMapItem(String key, String itemKey) {
        return extension.getValueIntMapItem(key, itemKey);
    }

    protected void putListList(String key, List values) {
        extension.putListList(key, values);
    }

    protected int putValueIntMapItem(String key, String itemKey, Integer value, boolean override) {
        return extension.putValueIntMapItem(key, itemKey, value, override);
    }

    protected <K, V> void removeMapItem(Class<K> classKey, Class<V> classValue, String key, K itemKey) {
        extension.removeMapItem(classKey, classValue, key, itemKey);
    }

    protected <V> V getListListItemItem(Class<V> classValue, String key, int index, int subIndex) {
        return extension.getListListItemItem(classValue, key, index, subIndex);
    }

    protected <SK, V> boolean containsListMapItemItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, SK subItemKey) {
        return extension.containsListMapItemItem(classSubKey, classValue, key, index, subItemKey);
    }

    protected Map textToMap(String extension_content) {
        return extension.textToMap(extension_content);
    }

    protected Map<String, Integer> getValueIntMap(String key) {
        return extension.getValueIntMap(key);
    }

    protected <V> int putKeyIntMapItem(Class<V> classValue, String key, Integer itemKey, V value) {
        return extension.putKeyIntMapItem(classValue, key, itemKey, value);
    }

    protected <K, V> int putMapListItemItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, V value, boolean override) {
        return extension.putMapListItemItem(classKey, classValue, key, itemKey, value, override);
    }

    protected List<String> getValueStringList(String key, List<String> defaultValues) {
        return extension.getValueStringList(key, defaultValues);
    }

    protected String getValueStringMapItem(String key, String itemKey) {
        return extension.getValueStringMapItem(key, itemKey);
    }

    protected <K, V> V getMapItem(Class<K> classKey, Class<V> classValue, String key, K itemKey) {
        return extension.getMapItem(classKey, classValue, key, itemKey);
    }

    protected <SK, V> V getListMapItemItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, SK subItemKey) {
        return extension.getListMapItemItem(classSubKey, classValue, key, index, subItemKey);
    }

    protected <T> T get(String key, T defaultVal, boolean putIfNotExsit) {
        return extension.get(key, defaultVal, putIfNotExsit);
    }

    protected <K, SK, V> Map<K, Map<SK, V>> getMapMap(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, Object defaultValue) {
        return extension.getMapMap(classKey, classSubKey, classValue, key, defaultValue);
    }

    protected <K, V> Map<K, V> getMap(Class<K> classKey, Class<V> classValue, String key) {
        return extension.getMap(classKey, classValue, key);
    }

    protected Set<String> keySet() {
        return extension.keySet();
    }

    protected List<Integer> getValueIntList(String key, List<Integer> defaultValues) {
        return extension.getValueIntList(key, defaultValues);
    }

    protected <T> List<T> getList(Class<T> classz, String key) {
        return extension.getList(classz, key);
    }

    protected <K, V> boolean containsMapListItemItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, V value) {
        return extension.containsMapListItemItem(classKey, classValue, key, itemKey, value);
    }

    protected <T> T get(String key, T defaultVal) {
        return extension.get(key, defaultVal);
    }

    protected boolean containsKey(String key) {
        return extension.containsKey(key);
    }

    public <SK, V> int putListMapItem(Class<SK> classSubKey, Class<V> classValue, String key, Map<SK, V> value) {
        return extension.putListMapItem(classSubKey, classValue, key, value);
    }

    protected <SK, V> int putListMapItemItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, SK subItemKey, V value) {
        return extension.putListMapItemItem(classSubKey, classValue, key, index, subItemKey, value);
    }

    protected <SK, V> boolean containsListMapItem(Class<SK> classSubKey, Class<V> classValue, String key, Map<SK, V> value) {
        return extension.containsListMapItem(classSubKey, classValue, key, value);
    }

    protected <K, V> List<V> getMapListItem(Class<K> classKey, Class<V> classValue, String key, K itemKey) {
        return extension.getMapListItem(classKey, classValue, key, itemKey);
    }

    protected static int copy(Object src, Object desc, String... descriptorNames) {
        return Extension.copy(src, desc, descriptorNames);
    }

    protected <K, V> Map<K, List<V>> getMapList(Class<K> classKey, Class<V> classValue, String key) {
        return extension.getMapList(classKey, classValue, key);
    }

    protected <K, SK, V> int putMapMapItemItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, SK subItemKey, V value) {
        return extension.putMapMapItemItem(classKey, classSubKey, classValue, key, itemKey, subItemKey, value);
    }

    protected <V> boolean containsKeyIntMapItem(Class<V> classValue, String key, Integer itemKey) {
        return extension.containsKeyIntMapItem(classValue, key, itemKey);
    }

    protected <SK, V> void removeListMapItemItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, SK subItemKey) {
        extension.removeListMapItemItem(classSubKey, classValue, key, index, subItemKey);
    }

    protected <K, SK, V> int putMapMapItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, Map<SK, V> value, boolean override) {
        return extension.putMapMapItem(classKey, classSubKey, classValue, key, itemKey, value, override);
    }

    protected <SK, V> List<Map<SK, V>> getListMap(Class<SK> classSubKey, Class<V> classValue, String key) {
        return extension.getListMap(classSubKey, classValue, key);
    }

    protected Object get(String key) {
        return extension.get(key);
    }

    protected <V> boolean containsKeyStringMapItem(Class<V> classValue, String key, String itemKey) {
        return extension.containsKeyStringMapItem(classValue, key, itemKey);
    }

    protected <V> List<List<V>> getListList(Class<V> classValue, String key) {
        return extension.getListList(classValue, key);
    }

    protected void putListMap(String key, List values) {
        extension.putListMap(key, values);
    }

    protected <K, SK, V> void removeMapMapItemItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, SK subItemKey) {
        extension.removeMapMapItemItem(classKey, classSubKey, classValue, key, itemKey, subItemKey);
    }

    protected void putMapMap(String key, Map values) {
        extension.putMapMap(key, values);
    }

    protected Object put(String key, Object val, boolean overrided) {
        return extension.put(key, val, overrided);
    }

    protected static int copy(boolean force, Object src, Object desc, String... descriptorNames) {
        return Extension.copy(force, src, desc, descriptorNames);
    }

    protected void putMapList(String key, Map values) {
        extension.putMapList(key, values);
    }

    protected <K, SK, V> V getMapMapItemItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, SK subItemKey) {
        return extension.getMapMapItemItem(classKey, classSubKey, classValue, key, itemKey, subItemKey);
    }

    protected void putMap(String key, Map values) {
        extension.putMap(key, values);
    }

    protected <V> Map<String, V> getKeyStringMap(Class<V> classValue, String key, Map<String, V> defaultValues) {
        return extension.getKeyStringMap(classValue, key, defaultValues);
    }

    protected <V> int putListListItemItem(Class<V> classValue, String key, int index, int subIndex, V value, boolean override) {
        return extension.putListListItemItem(classValue, key, index, subIndex, value, override);
    }

    protected <T> void removeListItem(Class<T> classz, String key, Object value) {
        extension.removeListItem(classz, key, value);
    }

    protected <SK, V> int putListMapItemItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, SK subItemKey, V value, boolean override) {
        return extension.putListMapItemItem(classSubKey, classValue, key, index, subItemKey, value, override);
    }

    protected int putValueStringMapItem(String key, String itemKey, String value) {
        return extension.putValueStringMapItem(key, itemKey, value);
    }

    protected <K, V> int putMapItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, V value) {
        return extension.putMapItem(classKey, classValue, key, itemKey, value);
    }

    protected boolean containsValue(Object val) {
        return extension.containsValue(val);
    }

    protected <V> int putListListItem(Class<V> classValue, String key, int index, List<V> value) {
        return extension.putListListItem(classValue, key, index, value);
    }

    protected Map<String, String> getValueStringMap(String key, Map<String, String> defaultValues) {
        return extension.getValueStringMap(key, defaultValues);
    }

    protected <V> boolean containsListListItemItem(Class<V> classValue, String key, int index, V value) {
        return extension.containsListListItemItem(classValue, key, index, value);
    }

    protected <K, V> V getMapListItemItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, int index) {
        return extension.getMapListItemItem(classKey, classValue, key, itemKey, index);
    }

    protected <V> V getKeyStringMapItem(Class<V> classValue, String key, String itemKey) {
        return extension.getKeyStringMapItem(classValue, key, itemKey);
    }

    protected <V> int putKeyStringMapItem(Class<V> classValue, String key, String itemKey, V value, boolean override) {
        return extension.putKeyStringMapItem(classValue, key, itemKey, value, override);
    }

    protected <T> List<T> getList(Class<T> classz, String key, List<T> defaultValue) {
        return extension.getList(classz, key, defaultValue);
    }

    protected <K, SK, V> boolean containsMapMapItemItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, SK subItemKey) {
        return extension.containsMapMapItemItem(classKey, classSubKey, classValue, key, itemKey, subItemKey);
    }

    protected int putValueIntListItem(String key, int value) {
        return extension.putValueIntListItem(key, value);
    }

    protected <T> T getListItem(Class<T> classz, String key, int index) {
        return extension.getListItem(classz, key, index);
    }

    protected <SK, V> int putListMapItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, Map<SK, V> value) {
        return extension.putListMapItem(classSubKey, classValue, key, index, value);
    }

    protected <V> void removeListListItem(Class<V> classValue, String key, int index) {
        extension.removeListListItem(classValue, key, index);
    }

    protected void putList(String key, List values) {
        extension.putList(key, values);
    }

    protected <SK, V> int putListMapItem(Class<SK> classSubKey, Class<V> classValue, String key, int index, Map<SK, V> value, boolean override) {
        return extension.putListMapItem(classSubKey, classValue, key, index, value, override);
    }

    protected <V> V getKeyIntMapItem(Class<V> classValue, String key, Integer itemKey) {
        return extension.getKeyIntMapItem(classValue, key, itemKey);
    }

    protected int getValueIntListItem(String key, int index) {
        return extension.getValueIntListItem(key, index);
    }

    protected int putValueStringMapItem(String key, String itemKey, String value, boolean override) {
        return extension.putValueStringMapItem(key, itemKey, value, override);
    }

    protected <K, V> int putMapItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, V value, boolean override) {
        return extension.putMapItem(classKey, classValue, key, itemKey, value, override);
    }

    protected void copyFrom(Extension target) {
        extension.copyFrom(target);
    }

    protected <SK, V> List<Map<SK, V>> getListMap(Class<SK> classSubKey, Class<V> classValue, String key, Object defaultValue) {
        return extension.getListMap(classSubKey, classValue, key, defaultValue);
    }

    protected <K, V> int putMapListItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, List<V> value, boolean override) {
        return extension.putMapListItem(classKey, classValue, key, itemKey, value, override);
    }

    protected void removeValueStringMapItem(String key, String itemKey) {
        extension.removeValueStringMapItem(key, itemKey);
    }

    protected <K, V> void removeMapListItemItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, int index) {
        extension.removeMapListItemItem(classKey, classValue, key, itemKey, index);
    }

    protected void removeValueIntMapItem(String key, String itemKey) {
        extension.removeValueIntMapItem(key, itemKey);
    }

    protected Object put(String key, Object val) {
        return extension.put(key, val);
    }

    protected String getStrProp(String key) {
        return extension.getStrProp(key);
    }

    protected <K, V> void removeMapListItem(Class<K> classKey, Class<V> classValue, String key, K itemKey) {
        extension.removeMapListItem(classKey, classValue, key, itemKey);
    }

    protected <V> Map<Integer, V> getKeyIntMap(Class<V> classValue, String key) {
        return extension.getKeyIntMap(classValue, key);
    }

    protected <T> int putListItem(Class<T> classz, String key, T value) {
        return extension.putListItem(classz, key, value);
    }

    protected <K, SK, V> void removeMapMapItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey) {
        extension.removeMapMapItem(classKey, classSubKey, classValue, key, itemKey);
    }

    protected <K, V> Map<K, List<V>> getMapList(Class<K> classKey, Class<V> classValue, String key, Object defaultValue) {
        return extension.getMapList(classKey, classValue, key, defaultValue);
    }

    protected <K, V> int putMapListItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, List<V> value) {
        return extension.putMapListItem(classKey, classValue, key, itemKey, value);
    }

    protected <V> Map<Integer, V> getKeyIntMap(Class<V> classValue, String key, Map<String, V> defaultValues) {
        return extension.getKeyIntMap(classValue, key, defaultValues);
    }

    protected Map<String, Integer> getValueIntMap(String key, Map<String, Integer> defaultValues) {
        return extension.getValueIntMap(key, defaultValues);
    }

    protected <K, SK, V> boolean containsMapMapItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey) {
        return extension.containsMapMapItem(classKey, classSubKey, classValue, key, itemKey);
    }

    protected int putValueIntListItem(String key, int value, boolean override) {
        return extension.putValueIntListItem(key, value, override);
    }

    protected <V> void removeKeyStringMapItem(Class<V> classValue, String key, String itemKey) {
        extension.removeKeyStringMapItem(classValue, key, itemKey);
    }

    protected <V> int putListListItem(Class<V> classValue, String key, int index, List<V> value, boolean override) {
        return extension.putListListItem(classValue, key, index, value, override);
    }

    protected <SK, V> Map<SK, V> getListMapItem(Class<SK> classSubKey, Class<V> classValue, String key, int index) {
        return extension.getListMapItem(classSubKey, classValue, key, index);
    }

    protected <K, V> Map<K, V> getMap(Class<K> classKey, Class<V> classValue, String key, Object defaultValue) {
        return extension.getMap(classKey, classValue, key, defaultValue);
    }

    protected <V> boolean containsListListItem(Class<V> classValue, String key, int index, List<V> value) {
        return extension.containsListListItem(classValue, key, index, value);
    }

    protected <K, V> int putMapListItemItem(Class<K> classKey, Class<V> classValue, String key, K itemKey, V value) {
        return extension.putMapListItemItem(classKey, classValue, key, itemKey, value);
    }

    protected List<Integer> getValueIntList(String key) {
        return extension.getValueIntList(key);
    }

    protected List<String> getValueStringList(String key) {
        return extension.getValueStringList(key);
    }

    protected <T> void removeListItem(Class<T> classz, String key, int index) {
        extension.removeListItem(classz, key, index);
    }

    protected <V> List<List<V>> getListList(Class<V> classValue, String key, Object defaultValue) {
        return extension.getListList(classValue, key, defaultValue);
    }

    protected Object coverPut(String key, Object val) {
        return extension.coverPut(key, val);
    }

    protected <V> void removeListListItemItem(Class<V> classValue, String key, int index, int subIndex) {
        extension.removeListListItemItem(classValue, key, index, subIndex);
    }

    protected <V> int putKeyStringMapItem(Class<V> classValue, String key, String itemKey, V value) {
        return extension.putKeyStringMapItem(classValue, key, itemKey, value);
    }

    protected void removeValueStringListItem(String key, Object value) {
        extension.removeValueStringListItem(key, value);
    }

    protected <V> int putListListItemItem(Class<V> classValue, String key, int index, int subIndex, V value) {
        return extension.putListListItemItem(classValue, key, index, subIndex, value);
    }

    protected <V> Map<String, V> getKeyStringMap(Class<V> classValue, String key) {
        return extension.getKeyStringMap(classValue, key);
    }

    protected int putValueStringListItem(String key, String value) {
        return extension.putValueStringListItem(key, value);
    }

    protected <V> List<V> getListListItem(Class<V> classValue, String key, int index) {
        return extension.getListListItem(classValue, key, index);
    }

    protected Object remove(String key) {
        return extension.remove(key);
    }

    protected int putValueIntMapItem(String key, String itemKey, Integer value) {
        return extension.putValueIntMapItem(key, itemKey, value);
    }

    protected <K, SK, V> Map<K, Map<SK, V>> getMapMap(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key) {
        return extension.getMapMap(classKey, classSubKey, classValue, key);
    }

    protected int putValueStringListItem(String key, String value, boolean override) {
        return extension.putValueStringListItem(key, value, override);
    }

    protected Map<String, String> getValueStringMap(String key) {
        return extension.getValueStringMap(key);
    }

    protected <SK, V> void removeListMapItem(Class<SK> classSubKey, Class<V> classValue, String key, int index) {
        extension.removeListMapItem(classSubKey, classValue, key, index);
    }

    protected <V> void removeKeyIntMapItem(Class<V> classValue, String key, Integer itemKey) {
        extension.removeKeyIntMapItem(classValue, key, itemKey);
    }

    protected void removeValueIntListItem(String key, Object value) {
        extension.removeValueIntListItem(key, value);
    }

    protected <T> boolean containsListItem(Class<T> classz, String key, T value) {
        return extension.containsListItem(classz, key, value);
    }

    protected <K, SK, V> int putMapMapItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey, Map<SK, V> value) {
        return extension.putMapMapItem(classKey, classSubKey, classValue, key, itemKey, value);
    }

    protected <T> int putListItem(Class<T> classz, String key, T value, boolean override) {
        return extension.putListItem(classz, key, value, override);
    }

    protected <K, SK, V> Map<SK, V> getMapMapItem(Class<K> classKey, Class<SK> classSubKey, Class<V> classValue, String key, K itemKey) {
        return extension.getMapMapItem(classKey, classSubKey, classValue, key, itemKey);
    }

    protected <V> int putKeyIntMapItem(Class<V> classValue, String key, Integer itemKey, V value, boolean override) {
        return extension.putKeyIntMapItem(classValue, key, itemKey, value, override);
    }

    protected String getValueStringListItem(String key, int index) {
        return extension.getValueStringListItem(key, index);
    }

    protected void removeValueIntListItem(String key, int index) {
        extension.removeValueIntListItem(key, index);
    }

    public <T> int putSetItem(Class<T> classz, String key, T value) {
        return extension.putSetItem(classz, key, value);
    }

    public <T> void removeSetItem(Class<T> classz, String key, Object value) {
        extension.removeSetItem(classz, key, value);
    }

    public <T> int putSetItem(Class<T> classz, String key, T value, boolean override, int maxSize, int removeStyle) {
        return extension.putSetItem(classz, key, value, override, maxSize, removeStyle);
    }

    public <T> T getSetItem(Class<T> classz, String key, int index) {
        return extension.getSetItem(classz, key, index);
    }

    public <T> int putSetItem(Class<T> classz, String key, T value, boolean override) {
        return extension.putSetItem(classz, key, value, override);
    }

    public <T> void removeSetItem(Class<T> classz, String key, int index) {
        extension.removeSetItem(classz, key, index);
    }

    public <T> Set<T> getSet(Class<T> classz, String key, Object defaultValue) {
        return extension.getSet(classz, key, defaultValue);
    }

    public <T> boolean containsSetItem(Class<T> classz, String key, T value) {
        return extension.containsSetItem(classz, key, value);
    }

    public void putSet(String key, Set values) {
        extension.putSet(key, values);
    }

    public <T> Set<T> getSet(Class<T> classz, String key) {
        return extension.getSet(classz, key);
    }
}
