package org.jsmth.jorm.domain;

import org.jsmth.domain.LongIdenticable;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * 为方便jdbc部分的使用，而构建的可扩展模型
 *
 * @author mason
 */
@SuppressWarnings({"unchecked"})
@MappedSuperclass
public abstract class ExtLongModel extends ExtModel<Long> implements LongIdenticable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    protected long id = 0;

    protected ExtLongModel() {
        super();
    }

    protected ExtLongModel(ExtModel<Long> src) {
        super(src);
    }

    @Override
    public Long getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Long id) {
        this.id = id;
    }

    @Override
    public boolean isIdModified() {
        return id!=0;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean isNewEntity() {
        return id == 0;
    }
}
