package org.jsmth.jorm.domain;

import org.jsmth.domain.IntIdenticable;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * 为方便jdbc部分的使用，而构建的可扩展模型
 *
 * @author mason
 */
@SuppressWarnings({"unchecked"})
@MappedSuperclass
public abstract class ExtIntModel extends ExtModel<Integer> implements IntIdenticable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    protected int id = 0;

    protected ExtIntModel() {
        super();
    }

    protected ExtIntModel(ExtModel<Integer> src) {
        super(src);
    }

    @Override
    public Integer getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Integer id) {
        this.id = id;
    }

    @Override
    public boolean isIdModified() {
        return id!=0;
    }

    @Override
    public int getId() {
        return id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public boolean isNewEntity() {
        return id == 0;
    }

    @Override
    public Class<Integer> getKeyClass() {
        return Integer.class;
    }
}
