package org.jsmth.jorm.domain;

import org.jsmth.domain.StringIdenticable;

import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;

/**
 * 主键为String类型的基础模型，一般当主键不适合使用long时使用
 *
 * @author mason
 */
@MappedSuperclass
public abstract class BaseStringModel extends BaseModel<String> implements StringIdenticable {

    @Id
    @NotNull(message = "primary key must be set")
    protected String id = null;

    protected BaseStringModel() {
    }

    protected BaseStringModel(BaseStringModel src) {
        super(src);
        this.id = src.id;
    }

    @Override
    public String getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(String id) {
        this.id = id;
    }

    @Override
    public boolean isIdModified() {
        return true;
    }

    public String getId() {
        return id;
    }

    /**
     * StringIdenticable需要显示的操作ID
     *
     * @param id id
     */
    public void setId(String id) {
        this.id = id;
    }

    public boolean isNewEntity() {
        return this.id == null;
    }

}
