package org.jsmth.jorm.domain;

import javax.persistence.*;
import java.io.Serializable;

/**
 *
 * @author mason
 */
@MappedSuperclass
public abstract class BaseProtoModel<KEY extends Serializable> implements Serializable {

    @Transient
    protected boolean disablePostLoad;
    @Transient
    protected boolean disablePreInsert;
    @Transient
    protected boolean disablePreUpdate;

    protected BaseProtoModel() {
    }


    @PrePersist
    public void preInsert() {
    }

    @PreUpdate
    public void preUpdate() {
    }

    @PostLoad
    public void postLoad() {
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        return true ;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().toString();
    }

    public boolean isDisablePostLoad() {
        return disablePostLoad;
    }

    public void setDisablePostLoad(boolean disablePostLoad) {
        this.disablePostLoad = disablePostLoad;
    }

    public boolean isDisablePreInsert() {
        return disablePreInsert;
    }

    public void setDisablePreInsert(boolean disablePreInsert) {
        this.disablePreInsert = disablePreInsert;
    }

    public boolean isDisablePreUpdate() {
        return disablePreUpdate;
    }

    public void setDisablePreUpdate(boolean disablePreUpdate) {
        this.disablePreUpdate = disablePreUpdate;
    }
}
