package org.jsmth.jorm.domain;

import org.jsmth.util.PropertyUtils;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 主键为int的自增长id基础模型
 * 切记为自己实现的主键加上getter和setter方法
 *
 * @author mason
 */
@MappedSuperclass
public abstract class BaseModel<KEY extends Serializable> extends ProtoModel<KEY> {

    public static final int DEFAULT_IN_MIN_OF_MAX_VALUE = 999;
    public static final int DEFAULT_IN_MAX_OF_MIN_VALUE = -999;

    @Transient
    protected boolean disableSetUpdateTime = false;

    @Column(name = "update_time")
    protected Date updateTime;

    protected BaseModel() {
    }

    protected BaseModel(BaseModel<KEY> src) {
        super(src);
        this.disableSetUpdateTime = src.disableSetUpdateTime;
        this.updateTime = src.updateTime;
    }

    public void preInsert() {
        if (!disableSetUpdateTime && this.updateTime == null) {
            this.updateTime = new Date();
        }
        super.preInsert();
    }

    public void preUpdate() {
        if (!disableSetUpdateTime) {
            this.updateTime = new Date();
        }
        super.preUpdate();
    }

    public void postLoad() {
        super.postLoad();
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setDisableSetUpdateTime(boolean disableSetUpdateTime) {
        this.disableSetUpdateTime = disableSetUpdateTime;
    }
    public void copyProperties(Object sourceObject) {
        PropertyUtils.copyProperties(sourceObject, this);
    }

    public void copyProperties(Object sourceObject, boolean copyNullProperty) {
        PropertyUtils.copyProperties(sourceObject, this, copyNullProperty);
    }

    public <T> T getPropertyValue(String field) {
        return PropertyUtils.getPropertyValue(this, field);
    }

    public void setPropertyValue(String field, Object value) {
        PropertyUtils.setPropertyValue(this, field, value);
    }

}
