package org.jsmth.jorm.domain;

import org.jsmth.domain.LongIdenticable;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * 主键为long的自增长id基础模型
 *
 * @author mason
 */
@MappedSuperclass
public abstract class BaseLongModel  extends BaseModel<Long> implements LongIdenticable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    protected long id = 0l;

    protected BaseLongModel() {
    }

    protected BaseLongModel(BaseLongModel src) {
        super(src);
        this.id = src.id;
    }

    //logics

    @Override
    public Long getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Long id) {
        this.id = id;
    }

    @Override
    public boolean isIdModified() {
        return id != 0l;
    }

    public long getId() {
        return id;
    }

    /**
     * 使用ORM时，绝大部分情况下都不需要显示操作id字段。
     *
     * @param id id
     */
    public void setId(long id) {
        this.id = id;
    }

    public boolean isNewEntity() {
        return this.id == 0l;
    }
}
