package org.jsmth.jorm.domain;

import org.jsmth.domain.IntIdenticable;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * 主键为int的自增长id基础模型
 *
 * @author mason
 */
@MappedSuperclass
public abstract class BaseIntModel extends BaseModel<Integer> implements IntIdenticable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    protected int id = 0;

    protected BaseIntModel() {
    }

    protected BaseIntModel(BaseIntModel src) {
        super(src);
        this.id = src.id;
    }

    //logics

    @Override
    public Integer getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Integer id) {
        this.id = id;
    }

    @Override
    public boolean isIdModified() {
        return id != 0l;
    }

    public int getId() {
        return id;
    }

    /**
     * 使用ORM时，绝大部分情况下都不需要显示操作id字段。
     *
     * @param id id
     */
    public void setId(int id) {
        this.id = id;
    }

    public boolean isNewEntity() {
        return this.id == 0;
    }

}
