package org.jsmth.jorm.daoservice;

import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.jorm.service.CommonEntityDao;
import org.jsmth.jorm.service.EntityDao;
import org.jsmth.jorm.service.EntityService;
import org.springframework.util.Assert;

import javax.annotation.PostConstruct;
import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 13-1-18
 * Time: 下午1:28
 */
public abstract class EntityDaoService<KEY extends Serializable, MODEL extends Identifier<KEY>> extends EntityService<KEY, MODEL, EntityDao<KEY, MODEL>> {
    protected JdbcDao jdbcDao;
    protected Class<MODEL> entityClass;
    protected Class<CommonEntityDao> entityDaoClass;

    public EntityDaoService(Class<MODEL> entityClass) {
        this.entityClass = entityClass;
        this.entityDao = new CommonEntityDao<KEY, MODEL>(entityClass);
        entityDaoClass=CommonEntityDao.class;
    }

    @PostConstruct
    @Override
    public void init() {
        super.init();
        Assert.notNull(entityClass, "entityClass must be set!");
        Assert.notNull(getJdbcDao(), "jdbcDao must be set!");
        this.entityDao.setJdbcDao(this.jdbcDao);
        this.entityDao.setBaseJdbcDao(this.jdbcDao);
    }

    @Override
    public void setEntityDao(EntityDao<KEY, MODEL> entityDao) {
        super.setEntityDao(entityDao);
    }

    public JdbcDao getJdbcDao() {
        return jdbcDao;
    }

    public void setJdbcDao(JdbcDao jdbcDao) {
        this.jdbcDao = jdbcDao;
        if(entityDao!=null){
            entityDao.setBaseJdbcDao(jdbcDao);
            entityDao.setJdbcDao(jdbcDao);
        }
    }

}
