package org.jsmth.jorm.action.cache;

import org.apache.commons.collections.CollectionUtils;
import org.jsmth.domain.Identifier;
import org.jsmth.page.CommonPage;
import org.jsmth.page.TailPage;

import java.io.Serializable;

/**
 * User: mason
 * Date: 2010-1-20
 * Time: 18:17:20
 */
public abstract class TailPagingCachebaleAction<KEY extends Serializable, MODEL extends Identifier> extends PagingCacheableQueryAction<KEY, MODEL> {

    protected boolean useCountCache = true;

    public int getCount() {
        if (useCache && useCountCache) {
            Integer ret = getCountInCache();
            if (ret == null) {
                ret = getCountInDB();
                putCountToCache(ret);
            }
            return ret;
        } else {
            return getCountInDB();
        }
    }

    protected int getCountInDB() {
        if (CollectionUtils.isEmpty(sqlParams))
            return jdbcDao.count(entityClass, sql.toString());
        else
            return jdbcDao.count(entityClass, sql.toString(), sqlParams.toArray());
    }

    public TailPage<MODEL> getTailPage() {
        return new CommonPage<MODEL>(pageNumber, pageSize, getCount(), getModels());
    }

    protected abstract Integer getCountInCache();

    protected abstract void putCountToCache(int count);
}
