package org.jsmth.jorm.action.cache;

import org.apache.commons.lang.Validate;
import org.jsmth.jorm.action.QueryAction;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.cache.Cache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * User: mason
 * Date: 2010-1-20
 * Time: 17:53:39
 */
public abstract class QueryCacheableAction<KEY extends Serializable, MODEL extends Identifier> extends QueryAction<KEY, MODEL> {

    protected Cache queryCache;

    public abstract Set<String> getRelatedKey(MODEL model);

    public abstract String getKey(Object... params);

    public abstract Cache getQueryCache();

    public void prepare(String name, boolean useCache, Class<MODEL> entityClass, JdbcDao jdbcDao, Cache entityCache, Cache queryCache, Object... params) {
        super.prepareBasic(name, useCache, entityClass, jdbcDao, entityCache);
        this.queryCache = queryCache;
        Validate.notNull(queryCache, "action queryCache must be set!");
        prepareParam(params);
        prepareSQL();
    }

    @SuppressWarnings({"unchecked"})
    @Override
    public List<KEY> getIds() {
        if (useCache) {
            List<KEY> ids = (List<KEY>) getQueryCache().get(getKey(params));
            if (ids == null) {
                ids = getIdsInDB();
                getQueryCache().put(getKey(params), ids);
            }
            return ids;
        } else {
            return (List<KEY>) getQueryCache().get(getKey(params));
        }
    }

    public void onEntityInsert(MODEL... models) {
        Set<String> keys = new HashSet<String>();
        for (MODEL model : models) {
            if (model != null)
                keys.addAll(getRelatedKey(model));
        }
        getQueryCache().removeMulti(keys);
    }

    public void onEntityDelete(MODEL... models) {
        Set<String> keys = new HashSet<String>();
        for (MODEL model : models) {
            if (model != null)
                keys.addAll(getRelatedKey(model));
        }
        getQueryCache().removeMulti(keys);
    }

}
