package org.jsmth.jorm.action;

import org.apache.commons.collections.CollectionUtils;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.SQLHelper;
import org.jsmth.page.CommonPage;
import org.jsmth.page.TailPage;

import java.io.Serializable;

/**
 * 带有尾页的分页查询action
 * User: mason
 * Date: 2010-1-20
 * Time: 15:23:25
 */
public abstract class TailPagingQueryAction<KEY extends Serializable, MODEL extends Identifier> extends PagingQueryAction<KEY, MODEL> {

    public TailPagingQueryAction() {
    }

    public int getCount() {
        return getCountInDB();
    }

    protected int getCountInDB() {
        if (CollectionUtils.isEmpty(sqlParams))
            return jdbcDao.count(entityClass, SQLHelper.removeOrders(sql.toString()));
        else
            return jdbcDao.count(entityClass, SQLHelper.removeOrders(sql.toString()), sqlParams.toArray());
    }

    public TailPage<MODEL> getTailPage() {
        return new CommonPage<MODEL>(pageNumber, pageSize, getCount(), getModels());
    }

}
