package org.jsmth.jorm.action;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.jorm.query.clause.OldClause;
import org.jsmth.cache.Cache;
import org.jsmth.page.Page;
import org.jsmth.page.RollPage;

import java.io.Serializable;
import java.util.List;

/**
 * 可滚动分页的查询action
 * User: mason
 * Date: 2010-1-20
 * Time: 14:52:54
 */
public abstract class PagingQueryAction<KEY extends Serializable, MODEL extends Identifier> extends QueryAction<KEY, MODEL> {

    protected int pageNumber = -1;
    protected int pageSize = -1;

    public PagingQueryAction() {
    }

    @Override
    public void prepare(String name, boolean useCache, Class<MODEL> entityClass, JdbcDao jdbcDao, Cache entityCache, Object... params) {
        super.prepare(name, useCache, entityClass, jdbcDao, entityCache, params);
        preparePaging();
        Validate.isTrue(pageNumber > -1, "pageNumber[" + pageNumber + "] must be prepared!");
        Validate.isTrue(pageSize > -1, "pageSize[" + pageSize + "] must be prepared!");
    }

    abstract protected void preparePaging();

    public Page<MODEL> getPage() {
        return new RollPage<MODEL>(pageNumber, pageSize, getModels());
    }

    @Override
    protected List<KEY> getIdsInDB() {
        StringBuilder pagingSql = new StringBuilder(sql);
        OldClause.paging(pagingSql, null, pageNumber, pageSize);

        if (CollectionUtils.isEmpty(sqlParams))
            return jdbcDao.findIds(entityClass, pagingSql.toString());
        else
            return jdbcDao.findIds(entityClass, pagingSql.toString(), sqlParams.toArray());
    }
}
