package org.jsmth.jorm.action;

import org.apache.commons.lang.Validate;
import org.jsmth.domain.Identifier;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 查询全部的查询action
 * User: mason
 * Date: 2010-1-20
 * Time: 15:29:50
 */
public class FindAllAction<KEY extends Serializable, MODEL extends Identifier> extends TailPagingQueryAction<KEY, MODEL> {

    boolean asc;

    public FindAllAction() {

    }

    @Override
    protected void prepareSQL() {
        Validate.isTrue(params.length == 3, "Params should be [asc][pageNumber][pageSize]");

        asc = (Boolean) params[0];

        sql.append("1=1 order by id ");
        if (asc)
            sql.append(" asc ");
        else
            sql.append(" desc ");
        sqlParams = new ArrayList();
    }

    @Override
    protected void preparePaging() {
        pageNumber = (Integer) params[1];
        pageSize = (Integer) params[2];
    }
}
