/*
Copyright (c) 2015 James Ahlborn

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.jsmth.data.sqlbuilder.custom;

import com.healthmarketscience.common.util.AppendableExt;
import org.jsmth.data.sqlbuilder.Expression;
import org.jsmth.data.sqlbuilder.ValidationContext;

import java.io.IOException;

/**
 * SqlObject expression which inserts a "named" parameter like {@code
 * ":<name>"}.  This syntax is used by various custom SQL or SQL-like
 * frameworks (e.g. Hibernate's HQL).
 *
 * @author James Ahlborn
 */
public class NamedParamObject extends Expression
{
  private String _name;

  public NamedParamObject(String name)
  {
    _name = name;
  }

  @Override
  protected void collectSchemaObjects(ValidationContext vContext) {
  }
  
  @Override
  public void appendTo(AppendableExt app) throws IOException {
    app.append(':').append(_name);
  }
}
