package org.jsmth.data.sql.wrap;

import org.jsmth.common.KeyValue;
import org.jsmth.data.sql.SqlQueryType;
import org.jsmth.data.sql.item.IWhereItem;
import org.jsmth.data.sql.item.Logic;
import org.jsmth.data.sql.item.where.*;


import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class WhereWrap extends AbstractSqlItemWrap implements IWhereItem ,IWhereWrap{
    LinkedList<KeyValue<Logic, IWhereItem>> items;
    NameParameterWhereWrap nameParameterWhereWrap;
    PlaceholderParameterWhereWrap placeholderParameterWhereWrap;
    protected SqlQueryType sqlQueryType = SqlQueryType.SQL;



    public WhereWrap() {
        items=new LinkedList<>();
        nameParameterWhereWrap=new NameParameterWhereWrap();
        placeholderParameterWhereWrap=new PlaceholderParameterWhereWrap();
    }
    @Override
    public boolean isEmpt() {
        return items.size()==0;
    }

    @Override
    public SqlQueryType getSqlQueryType() {
        return sqlQueryType;
    }

    public void setSqlQueryType(SqlQueryType sqlQueryType) {
        this.sqlQueryType = sqlQueryType;
    }
    public WhereWrap w(WhereWrap wrap){
        return w(Logic.AND,wrap);
    }
    public WhereWrap w(IWhereItem item){
        return w(Logic.AND,item);
    }
    public WhereWrap w(Logic logic, WhereWrap wrap){
        items.add(new KeyValue<Logic, IWhereItem>(logic,wrap));
        return this;
    }
    public WhereWrap w(Logic logic, IWhereItem item){
        items.add(new KeyValue<>(logic,item));
        return this;
    }
    public WhereWrap placeholderW(String where ,Object... params){
        LinkedList sqlParas=new LinkedList();
        for (Object param : params) {
            sqlParas.add(param);
        }
        return placeholderW(where,sqlParas);
    }
    public WhereWrap placeholderW(String where ,List sqlParas){
        this.sqlQueryType=SqlQueryType.Placeholder;
        placeholderParameterWhereWrap.w(where,sqlParas);
        return this;
    }


    public WhereWrap nameParameterW(String where, Map sqlParas) {
        this.sqlQueryType=SqlQueryType.NameParam;
        nameParameterWhereWrap.w(where,sqlParas);
        return this;
    }

    public void clear(){
        items.clear();
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (KeyValue<Logic, IWhereItem> item : items) {
            if(sql.length()>0){
                Logic logic=item.getKey();
                sql.append(" ");
                sql.append(logic.name());
                sql.append(" ");
            }
            IWhereItem whereItem = item.getValue();
            whereItem.setDialect(this.dialect);
            sql.append(whereItem.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        if(sqlQueryType==SqlQueryType.Placeholder){
            sql.append(placeholderParameterWhereWrap.getPlaceholderSql(sqlParas));
        }else{
            for (KeyValue<Logic, IWhereItem> item : items) {
                if(sql.length()>0){
                    Logic logic=item.getKey();
                    sql.append(" ");
                    sql.append(logic.name());
                    sql.append(" ");
                }
                IWhereItem whereItem = item.getValue();
                whereItem.setDialect(this.dialect);
                sql.append(whereItem.getPlaceholderSql(sqlParas));
            }
        }

        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas)  {
        StringBuilder sql=new StringBuilder();
        if(sqlQueryType==SqlQueryType.Placeholder){
            sql.append(nameParameterWhereWrap.getNameParamSql(sqlParas));
        }else{
            for (KeyValue<Logic, IWhereItem> item : items) {
                if(sql.length()>0){
                    Logic logic=item.getKey();
                    sql.append(" ");
                    sql.append(logic.name());
                    sql.append(" ");
                }
                IWhereItem whereItem = item.getValue();
                whereItem.setDialect(this.dialect);
                sql.append(whereItem.getNameParamSql(sqlParas));
            }
        }

        return sql.toString();
    }

    public LinkedList<KeyValue<Logic, IWhereItem>> getItems() {
        return items;
    }

    public void setItems(LinkedList<KeyValue<Logic, IWhereItem>> items) {
        this.items = items;
    }

    //<editor-fold desc="id">
    public WhereWrap wId(Object value) {
        IdWhereItem where = new IdWhereItem(value);
        return w(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="in">
    public WhereWrap wIn(Logic logic, String columnName, Object... values) {
        InWhereItem item = new InWhereItem( columnName, values);
        return w(logic, item);
    }

    public WhereWrap wIn(Logic logic, String columnName, boolean nullValueException, Object... values) {
        InWhereItem item = new InWhereItem( columnName, nullValueException, values);
        return w(logic, item);
    }

    public WhereWrap wIn(String columnName, Object... values) {
        InWhereItem item = new InWhereItem(columnName, values);
        return w(Logic.AND, item);
    }
    //</editor-fold>
    //<editor-fold desc="like">
    public WhereWrap wLike(Logic logic, String columnName, String keyword) {
        LikeWhereItem where = new LikeWhereItem( columnName, keyword);
        return w(logic, where);
    }

    public WhereWrap wLike(String columnName, String keyword) {
        LikeWhereItem where = new LikeWhereItem(columnName, keyword);
        return w(Logic.AND, where);
    }

    public WhereWrap wLike(Logic logic, String columnName, String keyword, boolean after) {
        LikeWhereItem where = new LikeWhereItem( columnName, keyword, after);
        return w(logic, where);
    }

    public WhereWrap wLike(String columnName, String keyword, boolean after) {
        LikeWhereItem where = new LikeWhereItem(columnName, keyword, after);
        return w(Logic.AND, where);
    }

    public WhereWrap wLike(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        LikeWhereItem where = new LikeWhereItem( columnName, keyword, before, after);
        return w(logic, where);
    }

    public WhereWrap wLike(String columnName, String keyword, boolean before, boolean after) {
        LikeWhereItem where = new LikeWhereItem(columnName, keyword, before, after);
        return w(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="lessthan">
    public WhereWrap wLessThan(Logic logic, String columnName, Object value) {
        LessThanWhereItem where = new LessThanWhereItem( columnName, value);
        return w(logic, where);
    }

    public WhereWrap wLessThan(String columnName, Object value) {
        LessThanWhereItem where = new LessThanWhereItem(columnName, value);
        return w(Logic.AND, where);
    }

    public WhereWrap wLessThan(Logic logic, String columnName, Object value, boolean equal) {
        LessThanWhereItem where = new LessThanWhereItem( columnName, value, equal);
        return w(logic, where);
    }

    public WhereWrap wLessThan(String columnName, Object value, boolean equal) {
        LessThanWhereItem where = new LessThanWhereItem(columnName, value, equal);
        return w(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="morethan">
    public WhereWrap wMoreThan(Logic logic, String columnName, Object value) {
        MoreThanWhereItem where = new MoreThanWhereItem( columnName, value);
        return w(logic, where);
    }

    public WhereWrap wMoreThan(String columnName, Object value) {
        MoreThanWhereItem where = new MoreThanWhereItem(columnName, value);
        return w(Logic.AND, where);
    }

    public WhereWrap wMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        MoreThanWhereItem where = new MoreThanWhereItem( columnName, value, equal);
        return w(logic, where);
    }

    public WhereWrap wMoreThan(String columnName, Object value, boolean equal) {
        MoreThanWhereItem where = new MoreThanWhereItem(columnName, value, equal);
        return w(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="notequal">
    public WhereWrap wNotEqual(Logic logic, String columnName, Object value) {
        NotEqualWhereItem where = new NotEqualWhereItem( columnName, value);
        return w(logic, where);
    }

    public WhereWrap wNotEqual(String columnName, Object value) {
        NotEqualWhereItem where = new NotEqualWhereItem(columnName, value);
        return w(Logic.AND, where);
    }

    public <ENUM extends Enum> WhereWrap wNotEqual(String columnName, ENUM value, boolean ordinal) {
        NotEqualWhereItem where = new NotEqualWhereItem(columnName, value, ordinal);
        return w(Logic.AND, where);
    }

    public <ENUM extends Enum> WhereWrap wNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        NotEqualWhereItem where = new NotEqualWhereItem( columnName, value, ordinal);
        return w(logic, where);
    }
    //</editor-fold>
    //<editor-fold desc="equal">
    public WhereWrap wEqual(Logic logic, String columnName, Object value) {
        EqualWhereItem where = new EqualWhereItem( columnName, value);
        w(Logic.AND, where);
        return this;
    }

    public WhereWrap wEqual(String columnName, Object value) {
        EqualWhereItem where = new EqualWhereItem(columnName, value);
        w(Logic.AND, where);
        return this;
    }

    public <ENUM extends Enum> WhereWrap wEqual(String columnName, ENUM value, boolean ordinal) {
        EqualWhereItem where = new EqualWhereItem(columnName, value, ordinal);
        return w(Logic.AND, where);
    }

    public <ENUM extends Enum> WhereWrap wEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        EqualWhereItem where = new EqualWhereItem( columnName, value, ordinal);
        return w(logic, where);
    }
    //</editor-fold>
    //<editor-fold desc="betweenthan">
    public WhereWrap wBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        BetweenThanWhereItem where = new BetweenThanWhereItem( columnName, beginValue, endValue);
        return w(logic, where);
    }

    public WhereWrap wBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        BetweenThanWhereItem where = new BetweenThanWhereItem(columnName, beginValue, beginEqual, endValue, endEqual);
        return w(Logic.AND, where);
    }

    public WhereWrap wBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        BetweenThanWhereItem where = new BetweenThanWhereItem( columnName, beginValue, beginEqual, endValue, endEqual);
        return w(logic, where);
    }
    //</editor-fold>
}
