package org.jsmth.data.sql.wrap;

import org.jsmth.data.sql.item.PatternUpdateItem;
import org.jsmth.data.sql.item.UpdateFieldItem;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * UPDATE 表名称 SET 列名称 = 新值 WHERE 列名称 = 某值
 */
public class UpdateFieldWrap extends AbstractSqlItemWrap {
    LinkedList<UpdateFieldItem> items;
    public UpdateFieldWrap() {
        items=new LinkedList<>();
    }

    public UpdateFieldWrap u(UpdateFieldWrap wrap){
        for (UpdateFieldItem item : wrap.getItems()) {
            u(item);
        }
        return  this;
    }
    public UpdateFieldWrap u(UpdateFieldItem item){
        items.add(item);
        return  this;
    }

    public UpdateFieldWrap u(String field) {
        return u(field,"");
    }
    public UpdateFieldWrap u(List<String> fields) {
        if(fields==null){
            return this;
        }
        for (String field : fields) {
            u(field);
        }
        return this;
    }
    public UpdateFieldWrap u(String field, Object value) {
        UpdateFieldItem item =new UpdateFieldItem(field,value);
        return u(item);
    }
    public UpdateFieldWrap u(String field,String pattern, Object value) {
        PatternUpdateItem item =new PatternUpdateItem(field,pattern,value);
        return u(item);
    }

    public void clear(){
        items.clear();
    }

    @Override
    public boolean isEmpt() {
        return items.size()==0;
    }
    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (UpdateFieldItem item : items) {
            if(sql.length()>0){
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (UpdateFieldItem item : items) {
            if(sql.length()>0){
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas)  {
        StringBuilder sql=new StringBuilder();
        for (UpdateFieldItem item : items) {
            if(sql.length()>0){
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public LinkedList<UpdateFieldItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<UpdateFieldItem> items) {
        this.items = items;
    }
}
