package org.jsmth.data.sql.wrap;

import org.jsmth.data.sql.item.SelectItem;
import org.jsmth.data.sql.item.SelectMethod;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class SelectWrap extends AbstractSqlItemWrap {
    LinkedList<SelectItem> items;
    public SelectWrap() {
        items=new LinkedList<>();
    }

    public SelectWrap select(SelectWrap wrap){
        for (SelectItem item : wrap.getItems()) {
            select(item);
        }
        return  this;
    }
    public SelectWrap select(SelectItem item){
        items.add(item);
        return  this;
    }

    public SelectWrap select(String columnName, String aliasName, SelectMethod selectMethod) {
        SelectItem clause = new SelectItem(columnName, aliasName, selectMethod);
        return select(clause);
    }

    public SelectWrap select(String columnName, String aliasName) {
        SelectItem clause = new SelectItem(columnName, aliasName);
        return select(clause);
    }
    public SelectWrap select(String columnName) {
        return select(columnName,"");
    }

    public void clear(){
        items.clear();
    }

    @Override
    public boolean isEmpt() {
        return items.size()==0;
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (SelectItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (SelectItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas)  {
        StringBuilder sql=new StringBuilder();
        for (SelectItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }
    public LinkedList<SelectItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<SelectItem> items) {
        this.items = items;
    }
}
