package org.jsmth.data.sql.wrap;

import org.apache.commons.lang.StringUtils;
import org.jsmth.data.sql.SqlQueryType;
import org.jsmth.data.sql.item.IWhereItem;

import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class PlaceholderParameterWhereWrap extends AbstractSqlItemWrap implements IWhereItem ,IWhereWrap{
    String sql="";
    List sqlNameParas;
    SqlQueryType sqlQueryType = SqlQueryType.Placeholder;


    public PlaceholderParameterWhereWrap() {
        sqlNameParas =new LinkedList<>();
    }

    public PlaceholderParameterWhereWrap(String sql, List sqlParas) {
        this.sql = sql;
        this.sqlNameParas = sqlParas;
    }
    public PlaceholderParameterWhereWrap(String sql, Object... params) {
        this.sql = sql;
        this.sqlNameParas = new LinkedList<>();
        if(params!=null){
            for (Object param : params) {
                sqlNameParas.add(param);
            }
        }
    }

    @Override
    public boolean isEmpt() {
        return StringUtils.isBlank(sql);
    }

    public PlaceholderParameterWhereWrap w(String sql, List sqlParas){
        this.sql = sql;
        this.sqlNameParas = sqlParas;
        return this;
    }

    public void clear(){

    }

    //
    @Override
    public String getSql() {
        return sql;
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        sqlParas.addAll(sqlNameParas);
        return sql;
    }
    @Override
    public String   getNameParamSql(Map sqlParas)  {
        throw new IllegalArgumentException("PlaceholderParameterWhereWrap not use NameParamSql!");
    }

    public SqlQueryType getSqlQueryType() {
        return sqlQueryType;
    }

    public void setSqlQueryType(SqlQueryType sqlQueryType) {
        this.sqlQueryType = sqlQueryType;
    }
}
