package org.jsmth.data.sql.wrap;

import org.jsmth.data.sql.item.*;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class OrderWrap  extends AbstractSqlItemWrap {
    LinkedList<OrderItem> items;
    public OrderWrap() {
        items=new LinkedList<>();
    }

    public OrderWrap order(OrderWrap wrap){
        for (OrderItem item : wrap.getItems()) {
            order(item);
        }
        return  this;
    }
    public OrderWrap order(OrderItem item){
        items.add(item);
        return  this;
    }
    public OrderWrap order(String fieldName){
        return  order(fieldName,OrderType.ASC);
    }
    public OrderWrap order(String fieldName,OrderType style){
        OrderItem item=new OrderItem(fieldName,style);
        return  order(item);
    }

    public void clear(){
        items.clear();
    }

    @Override
    public boolean isEmpt() {
        return items.size()==0;
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (OrderItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (OrderItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (OrderItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public LinkedList<OrderItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<OrderItem> items) {
        this.items = items;
    }
}
