package org.jsmth.data.sql.wrap;

import org.apache.commons.lang.StringUtils;
import org.jsmth.data.sql.SqlQueryType;
import org.jsmth.data.sql.item.IWhereItem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class NameParameterWhereWrap extends AbstractSqlItemWrap implements IWhereItem,IWhereWrap {
    String sql="";
    Map sqlNameParas;
    SqlQueryType sqlQueryType = SqlQueryType.NameParam;


    public NameParameterWhereWrap() {
        sqlNameParas =new LinkedHashMap<>();
    }

    public NameParameterWhereWrap(String sql, Map sqlParas) {
        this.sql = sql;
        this.sqlNameParas = sqlParas;
    }

    @Override
    public boolean isEmpt() {
        return StringUtils.isBlank(sql);
    }

    public NameParameterWhereWrap w(String sql, Map sqlParas){
        this.sql = sql;
        this.sqlNameParas = sqlParas;
        return this;
    }

    public void clear(){

    }

    @Override
    public String getSql() {
        return sql;
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        throw new IllegalArgumentException("NameParameterWhereWrap not use PlaceholderSql!");
    }
    @Override
    public String getNameParamSql(Map sqlParas)  {
        sqlParas.putAll(sqlNameParas);
        return sql.toString();
    }

    public SqlQueryType getSqlQueryType() {
        return sqlQueryType;
    }

    public void setSqlQueryType(SqlQueryType sqlQueryType) {
        this.sqlQueryType = sqlQueryType;
    }
}
