package org.jsmth.data.sql.wrap;

import org.jsmth.data.sql.item.InsertFieldItem;
import org.jsmth.data.sql.item.InsertValueItem;
import org.jsmth.data.sql.item.PatternInsertValueItem;
import org.jsmth.data.sql.item.InsertValueItem;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 * INSERT INTO table_name (列1, 列2,...) VALUES (值1, 值2,....)
 */
public class InsertValueWrap extends AbstractSqlItemWrap {
    LinkedList<InsertValueItem> items;

    public InsertValueWrap() {
        items = new LinkedList<>();
    }

    public InsertValueWrap v(InsertValueWrap wrap) {
        for (InsertValueItem item : wrap.getItems()) {
            v(item);
        }
        return this;
    }

    public InsertValueWrap v(InsertValueItem item) {
        items.add(item);
        return this;
    }

    public InsertValueWrap v(String field, Object value) {
        InsertValueItem item = new InsertValueItem(field, value);
        return v(item);
    }

    public InsertValueWrap v(String field, String pattern, Object value) {
        PatternInsertValueItem item = new PatternInsertValueItem(field, pattern, value);
        return v(item);
    }

    public void clear(){
        items.clear();
    }

    @Override
    public boolean isEmpt() {
        return items.size() == 0;
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (InsertValueItem item : items) {
            if(sql.length()>0){
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (InsertValueItem item : items) {
            if(sql.length()>0){
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas)  {
        StringBuilder sql=new StringBuilder();
        for (InsertValueItem item : items) {
            if(sql.length()>0){
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public LinkedList<InsertValueItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<InsertValueItem> items) {
        this.items = items;
    }
}
