package org.jsmth.data.sql.wrap;

import org.jsmth.data.sql.item.InsertFieldItem;
import org.jsmth.data.sql.item.InsertFieldItem;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 * INSERT INTO table_name (列1, 列2,...) VALUES (值1, 值2,....)
 */
public class InsertFieldWrap extends AbstractSqlItemWrap {
    LinkedList<InsertFieldItem> items;

    public InsertFieldWrap() {
        items = new LinkedList<>();
    }

    public InsertFieldWrap f(InsertFieldWrap wrap) {
        for (InsertFieldItem item : wrap.getItems()) {
            f(item);
        }
        return this;
    }

    public InsertFieldWrap f(InsertFieldItem item) {
        items.add(item);
        return this;
    }

    public InsertFieldWrap f(String field) {
        return f(field,"");
    }
    public InsertFieldWrap f(String field, Object value) {
        InsertFieldItem item = new InsertFieldItem(field, value);
        return f(item);
    }

    public void clear(){
        items.clear();
    }

    @Override
    public boolean isEmpt() {
        return items.size() == 0;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        for (InsertFieldItem item : items) {
            if (sql.length() > 0) {
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        for (InsertFieldItem item : items) {
            if (sql.length() > 0) {
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        for (InsertFieldItem item : items) {
            if (sql.length() > 0) {
                sql.append(" , ");
            }
            item.setDialect(this.dialect);
            sql.append(item.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public LinkedList<InsertFieldItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<InsertFieldItem> items) {
        this.items = items;
    }
}
