package org.jsmth.data.sql.wrap;

import org.jsmth.common.KeyValue;
import org.jsmth.data.sql.item.IWhereItem;
import org.jsmth.data.sql.item.Logic;
import org.jsmth.data.sql.item.where.*;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class HavingWrap extends AbstractSqlItemWrap implements IWhereItem {
    LinkedList<KeyValue<Logic, IWhereItem>> items;

    public HavingWrap() {
        items=new LinkedList<>();
    }
    @Override
    public boolean isEmpt() {
        return items.size()==0;
    }

    public HavingWrap h(HavingWrap wrap){
        return h(Logic.AND, wrap);
    }
    public HavingWrap h(IWhereItem item){
        return h(Logic.AND, item);
    }
    public HavingWrap h(Logic logic, HavingWrap wrap){
        items.add(new KeyValue<Logic, IWhereItem>(logic,wrap));
        return this;
    }
    public HavingWrap h(Logic logic, IWhereItem item){
        items.add(new KeyValue<>(logic,item));
        return this;
    }

    public void clear(){
        items.clear();
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (KeyValue<Logic, IWhereItem> item : items) {
            if(sql.length()>0){
                Logic logic=item.getKey();
                sql.append(" ");
                sql.append(logic.name());
                sql.append(" ");
            }
            IWhereItem whereItem = item.getValue();
            whereItem.setDialect(this.dialect);
            sql.append(whereItem.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (KeyValue<Logic, IWhereItem> item : items) {
            if(sql.length()>0){
                Logic logic=item.getKey();
                sql.append(" ");
                sql.append(logic.name());
                sql.append(" ");
            }
            IWhereItem whereItem = item.getValue();
            whereItem.setDialect(this.dialect);
            sql.append(whereItem.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (KeyValue<Logic, IWhereItem> item : items) {
            if(sql.length()>0){
                Logic logic=item.getKey();
                sql.append(" ");
                sql.append(logic.name());
                sql.append(" ");
            }
            IWhereItem whereItem = item.getValue();
            whereItem.setDialect(this.dialect);
            sql.append(whereItem.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public LinkedList<KeyValue<Logic, IWhereItem>> getItems() {
        return items;
    }

    public void setItems(LinkedList<KeyValue<Logic, IWhereItem>> items) {
        this.items = items;
    }

    //<editor-fold desc="id">
    public HavingWrap hId(Object value) {
        IdWhereItem where = new IdWhereItem(value);
        return h(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="in">
    public HavingWrap hIn(Logic logic, String columnName, Object... values) {
        InWhereItem item = new InWhereItem( columnName, values);
        return h(logic, item);
    }

    public HavingWrap hIn(Logic logic, String columnName, boolean nullValueException, Object... values) {
        InWhereItem item = new InWhereItem( columnName, nullValueException, values);
        return h(logic, item);
    }

    public HavingWrap hIn(String columnName, Object... values) {
        InWhereItem item = new InWhereItem(columnName, values);
        return h(Logic.AND, item);
    }
    //</editor-fold>
    //<editor-fold desc="like">
    public HavingWrap hLike(Logic logic, String columnName, String keyword) {
        LikeWhereItem where = new LikeWhereItem( columnName, keyword);
        return h(logic, where);
    }

    public HavingWrap hLike(String columnName, String keyword) {
        LikeWhereItem where = new LikeWhereItem(columnName, keyword);
        return h(Logic.AND, where);
    }

    public HavingWrap hLike(Logic logic, String columnName, String keyword, boolean after) {
        LikeWhereItem where = new LikeWhereItem( columnName, keyword, after);
        return h(logic, where);
    }

    public HavingWrap hLike(String columnName, String keyword, boolean after) {
        LikeWhereItem where = new LikeWhereItem(columnName, keyword, after);
        return h(Logic.AND, where);
    }

    public HavingWrap hLike(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        LikeWhereItem where = new LikeWhereItem( columnName, keyword, before, after);
        return h(logic, where);
    }

    public HavingWrap hLike(String columnName, String keyword, boolean before, boolean after) {
        LikeWhereItem where = new LikeWhereItem(columnName, keyword, before, after);
        return h(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="lessthan">
    public HavingWrap hLessThan(Logic logic, String columnName, Object value) {
        LessThanWhereItem where = new LessThanWhereItem( columnName, value);
        return h(logic, where);
    }

    public HavingWrap hLessThan(String columnName, Object value) {
        LessThanWhereItem where = new LessThanWhereItem(columnName, value);
        return h(Logic.AND, where);
    }

    public HavingWrap hLessThan(Logic logic, String columnName, Object value, boolean equal) {
        LessThanWhereItem where = new LessThanWhereItem( columnName, value, equal);
        return h(logic, where);
    }

    public HavingWrap hLessThan(String columnName, Object value, boolean equal) {
        LessThanWhereItem where = new LessThanWhereItem(columnName, value, equal);
        return h(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="morethan">
    public HavingWrap hMoreThan(Logic logic, String columnName, Object value) {
        MoreThanWhereItem where = new MoreThanWhereItem( columnName, value);
        return h(logic, where);
    }

    public HavingWrap hMoreThan(String columnName, Object value) {
        MoreThanWhereItem where = new MoreThanWhereItem(columnName, value);
        return h(Logic.AND, where);
    }

    public HavingWrap hMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        MoreThanWhereItem where = new MoreThanWhereItem( columnName, value, equal);
        return h(logic, where);
    }

    public HavingWrap hMoreThan(String columnName, Object value, boolean equal) {
        MoreThanWhereItem where = new MoreThanWhereItem(columnName, value, equal);
        return h(Logic.AND, where);
    }
    //</editor-fold>
    //<editor-fold desc="notequal">
    public HavingWrap hNotEqual(Logic logic, String columnName, Object value) {
        NotEqualWhereItem where = new NotEqualWhereItem( columnName, value);
        return h(logic, where);
    }

    public HavingWrap hNotEqual(String columnName, Object value) {
        NotEqualWhereItem where = new NotEqualWhereItem(columnName, value);
        return h(Logic.AND, where);
    }

    public <ENUM extends Enum> HavingWrap hNotEqual(String columnName, ENUM value, boolean ordinal) {
        NotEqualWhereItem where = new NotEqualWhereItem(columnName, value, ordinal);
        return h(Logic.AND, where);
    }

    public <ENUM extends Enum> HavingWrap hNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        NotEqualWhereItem where = new NotEqualWhereItem( columnName, value, ordinal);
        return h(logic, where);
    }
    //</editor-fold>
    //<editor-fold desc="equal">
    public HavingWrap hEqual(Logic logic, String columnName, Object value) {
        EqualWhereItem where = new EqualWhereItem( columnName, value);
        h(Logic.AND, where);
        return this;
    }

    public HavingWrap hEqual(String columnName, Object value) {
        EqualWhereItem where = new EqualWhereItem(columnName, value);
        h(Logic.AND, where);
        return this;
    }

    public <ENUM extends Enum> HavingWrap hEqual(String columnName, ENUM value, boolean ordinal) {
        EqualWhereItem where = new EqualWhereItem(columnName, value, ordinal);
        return h(Logic.AND, where);
    }

    public <ENUM extends Enum> HavingWrap hEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        EqualWhereItem where = new EqualWhereItem( columnName, value, ordinal);
        return h(logic, where);
    }
    //</editor-fold>
    //<editor-fold desc="betweenthan">
    public HavingWrap hBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        BetweenThanWhereItem where = new BetweenThanWhereItem( columnName, beginValue, endValue);
        return h(logic, where);
    }

    public HavingWrap hBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        BetweenThanWhereItem where = new BetweenThanWhereItem(columnName, beginValue, beginEqual, endValue, endEqual);
        return h(Logic.AND, where);
    }

    public HavingWrap hBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        BetweenThanWhereItem where = new BetweenThanWhereItem( columnName, beginValue, beginEqual, endValue, endEqual);
        return h(logic, where);
    }
    //</editor-fold>
}
