package org.jsmth.data.sql.wrap;

import org.jsmth.data.sql.item.GroupItem;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class GroupWrap extends AbstractSqlItemWrap {
    LinkedList<GroupItem> items;
    public GroupWrap() {
        items=new LinkedList<>();
    }

    public GroupWrap Group(GroupWrap wrap){
        for (GroupItem item : wrap.getItems()) {
            group(item);
        }
        return  this;
    }
    public GroupWrap group(GroupItem item){
        items.add(item);
        return  this;
    }
    public GroupWrap group(String fieldName){
        GroupItem item=new GroupItem(fieldName);
        return  group(item);
    }

    public void clear(){
        items.clear();
    }

    @Override
    public boolean isEmpt() {
        return items.size()==0;
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        for (GroupItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (GroupItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql=new StringBuilder();
        for (GroupItem item : items) {
            if(sql.length()>0){
                sql.append(",");
            }
            item.setDialect(this.dialect);
            sql.append(item.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public LinkedList<GroupItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<GroupItem> items) {
        this.items = items;
    }
}
