package org.jsmth.data.sql.wrap;

import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Index;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.item.CreateIndexItem;
import org.jsmth.data.sql.support.HibernateEntity;
import org.jsmth.data.sql.support.HibernateMapping;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/21.
 */
public class CreateIndexWrap extends AbstractSqlItemWrap {

    TableSchema tableSchema;
    Dialect hibernateDialect;
    LinkedList<CreateIndexItem> items;

    public CreateIndexWrap( TableSchema tableSchema, Dialect hibernateDialect) {
        this.tableSchema = tableSchema;
        this.hibernateDialect = hibernateDialect;
        items=new LinkedList<>();
    }

    @Override
    public String getSql() {
        HibernateEntity hTableEntity = HibernateMapping.getHTable(tableSchema.getEntityClass(), hibernateDialect);
        List<String> list = new LinkedList<String>();
        Iterator indexes = hTableEntity.getTable().getIndexIterator();
        while (indexes.hasNext()) {
            Index index = (Index) indexes.next();
            CreateIndexItem item=new CreateIndexItem(index,tableSchema,hibernateDialect);
            items.add(item);
        }
        return "";
    }

    public void clear(){
        items.clear();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }

    public List<CreateIndexItem> getItems() {
        return items;
    }

    public void setItems(LinkedList<CreateIndexItem> items) {
        this.items = items;
    }
}
