package org.jsmth.data.sql.support;

import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.springframework.dao.DataAccessException;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.*;

/**
 * Created by mason on 15/12/21.
 */
public class HibernateMapping {
    //static Map<Class, HibernateEntity> hibernateEntiytMap = new LinkedHashMap<Class, HibernateEntity>();

    public static HibernateEntity getHTable(Class entityClass, Dialect dialect) {
//        if(hibernateEntiytMap.containsKey(entityClass)){
//            return hibernateEntiytMap.get(entityClass);
//        }
        Configuration cfg = new Configuration();
        cfg.addAnnotatedClass(entityClass);
        Mapping mapping = cfg.buildMapping();
        cfg.buildMappings();
        // hibernate table
        org.hibernate.mapping.Table table = getTable(cfg, dialect);
        //resort columns
        resortTableColumn(table, dialect, mapping);
        String defaultCatalog = cfg.getProperties().getProperty(Environment.DEFAULT_CATALOG);
        String defaultSchema = cfg.getProperties().getProperty(Environment.DEFAULT_SCHEMA);

        HibernateEntity hibernateEntiyt=new HibernateEntity();
        hibernateEntiyt.setConfiguration(cfg);
        hibernateEntiyt.setMapping(mapping);
        hibernateEntiyt.setTable(table);
        hibernateEntiyt.setDefaultCatalog(defaultCatalog);
        hibernateEntiyt.setDefaultSchema(defaultSchema);
//        hibernateEntiytMap.put(entityClass, hibernateEntiyt);
        return hibernateEntiyt;
    }

    public static org.hibernate.mapping.Table getTable(Configuration cfg, Dialect dialect) throws DataAccessException {
        org.hibernate.mapping.Table table = (org.hibernate.mapping.Table) cfg.getTableMappings().next();
        Mapping mapping = cfg.buildMapping();
        resortTableColumn(table, dialect, mapping);
        table.sqlCreateString(dialect, mapping, cfg.getProperties().getProperty(Environment.DEFAULT_CATALOG), cfg.getProperties().getProperty(Environment.DEFAULT_SCHEMA));
        return table;
    }

    /**
     * 对字段进行重排序，hibernate只会根据字段默认次序排序，导致建表语句很烂
     *
     * @param table   d
     * @param dialect d
     * @param mapping d
     */
    public static void resortTableColumn(org.hibernate.mapping.Table table, final Dialect dialect, final Mapping mapping) throws DataAccessException {
        List<Column> columns = new LinkedList<Column>();
        List<Column> tempcolumns = new LinkedList<Column>();

        Set<Column> indexedColumn = new HashSet<Column>();
        Iterator idxit = table.getIndexIterator();
        while (idxit.hasNext()) {
            Index o = (Index) idxit.next();
            Iterator ci = o.getColumnIterator();
            while (ci.hasNext()) {
                Column column = (Column) ci.next();
                indexedColumn.add(column);
            }
        }
        indexedColumn.addAll(table.getPrimaryKey().getColumns());
        Iterator keyIterator = table.getForeignKeyIterator();
        while (keyIterator.hasNext()) {
            Column o = (Column) keyIterator.next();
            indexedColumn.add(o);
        }

        Iterator<Column> iterator = table.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = iterator.next();
            //已经被索引的列，将直接按先后次序使用
            if (indexedColumn.contains(column)) {
                columns.add(column);
            } else {
                tempcolumns.add(column);
            }
        }

        //调整那些未被索引的列次序
        Collections.sort(tempcolumns, new Comparator<Column>() {
            @Override
            public int compare(Column o1, Column o2) {
                Integer order1 = ORDERED_SQL_TYPES.get(o1.getSqlTypeCode(mapping));
                Integer order2 = ORDERED_SQL_TYPES.get(o2.getSqlTypeCode(mapping));

                if (order1 != null && order2 != null) {
                    int ret = order1 - order2;
                    if (ret == 0) {
                        ret = o1.getLength() - o2.getLength();
                    }
                    return ret;
                } else if (order1 == null && order2 != null)
                    return -1;
                else if (order1 != null)
                    return 1;
                else {
                    //都是未知类型，则不排序
                    return 0;
                }
            }
        });

        columns.addAll(tempcolumns);

        Field field = ReflectionUtils.findField(org.hibernate.mapping.Table.class, "columns");
        ReflectionUtils.makeAccessible(field);
        try {
            Map map = (Map) field.get(table);
            map.clear();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (Column column : columns) {
            table.addColumn(column);
        }
    }


    /**
     * Types.NULL
     * Types.BOOLEAN
     * Types.BIT
     * Types.CHAR
     * Types.NCHAR
     * Types.TINYINT
     * Types.SMALLINT
     * Types.INTEGER
     * Types.DECIMAL
     * Types.BIGINT
     * Types.DOUBLE
     * Types.FLOAT
     * Types.NUMERIC
     * Types.TIME
     * Types.DATE
     * Types.TIMESTAMP
     * Types.VARCHAR
     * Types.NVARCHAR
     * Types.ARRAY
     * Types.BINARY
     * Types.DATALINK
     * Types.DISTINCT
     * Types.OTHER
     * Types.REAL
     * Types.REF
     * Types.ROWID
     * Types.SQLXML
     * Types.STRUCT
     * Types.VARBINARY
     * Types.JAVA_OBJECT
     * Types.LONGVARCHAR
     * Types.LONGNVARCHAR
     * Types.LONGVARBINARY
     * Types.BLOB
     * Types.NCLOB
     * Types.CLOB
     */



    //
    static final int[] SQL_TYPES = new int[]{Types.NULL, Types.BOOLEAN, Types.BIT, Types.CHAR, Types.NCHAR, Types.TINYINT, Types.SMALLINT, Types.INTEGER, Types.DECIMAL, Types.BIGINT, Types.DOUBLE, Types.FLOAT, Types.NUMERIC, Types.TIME, Types.DATE, Types.TIMESTAMP, Types.VARCHAR, Types.NVARCHAR, Types.ARRAY, Types.BINARY, Types.DATALINK, Types.DISTINCT, Types.OTHER, Types.REAL, Types.REF, Types.ROWID, Types.SQLXML, Types.STRUCT, Types.VARBINARY, Types.JAVA_OBJECT, Types.LONGVARCHAR, Types.LONGNVARCHAR, Types.LONGVARBINARY, Types.CLOB, Types.NCLOB, Types.BLOB};
    static final Map<Integer, Integer> ORDERED_SQL_TYPES = new LinkedHashMap<Integer, Integer>();

    static {
        int idx = 0;
        for (int i : SQL_TYPES) {
            ORDERED_SQL_TYPES.put(i, idx);
            idx++;
        }
    }

}
