package org.jsmth.data.sql.sqlbuilder;

import org.jsmth.data.code.sqlbuilder.IllegalQueryException;
import org.jsmth.data.sql.item.Logic;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/11/28.
 */
public class Where implements Cloneable {
    StringBuilder sql = new StringBuilder();
    List sqlParas = new ArrayList<>();
    int pageNumber=0;
    int pageSize=0;
    boolean totalRecord=false;

    public Where() {
    }

    public Where(String where, List sqlParas) {
        this.sql.append(where);
        if(sqlParas!=null && sqlParas.size()>0) {
            this.sqlParas.addAll(sqlParas);
        }
    }
    public Where(String where, Object... sqlParas) {
        this.sql.append(where);
        if(sqlParas!=null && sqlParas.length>0) {
            for (Object sqlPara : sqlParas) {
                this.sqlParas.add(sqlPara);
            }
        }
    }
    public Where(Where where){
        this.sql.append(where.buildSql());
        this.sqlParas=where.getSqlParas();
    }
    public Where limit(int pageNumber,int pageSize) {
        return limit(false,pageNumber,pageSize);
    }
    public Where limit(boolean totalRecord,int pageNumber,int pageSize){
        this.totalRecord=totalRecord;
        this.pageNumber=pageNumber;
        this.pageSize=pageSize;
        return this;
    }

    public Where combine(Where where)
    {
        return combine(Logic.AND,where);
    }
    public Where combine(Logic logic, Where where){
        w(logic,where.buildSql(),where.getSqlParas().toArray());
        return this;
    }

    public String buildSql() {
        return sql.toString();
    }

    public List getSqlParas() {
        return sqlParas;
    }

    public void printSqlParams(){
        int index=0;
        for (Object sqlPara : sqlParas) {
            if(sqlPara==null){
                System.out.println("PARA "+index +" null");
            }else{
                System.out.println("PARA "+index +" "+sqlPara.toString());
            }
            index++;
        }
    }
    public Where clone() {
        Where where = new Where(this.sql.toString(), sqlParas);
        return where;
    }

    public Where w(String sql, Object... params) {
        return w(Logic.AND, sql, params);
    }

    public Where w(Logic logic, String sql, Object... params) {
        boolean app=this.sql.length() > 0;
        if (app) {
            this.sql.insert(0, "(");
            this.sql.append(")");
            switch (logic) {
                case AND:
                    this.sql.append(" AND ");
                    break;
                case OR:
                    this.sql.append(" OR ");
                    break;
                case NOT:
                    this.sql.append(" NOT ");
                    break;
            }
            this.sql.append(" (");
        }
        this.sql.append(sql);
        if(params!=null){
            for (Object param : params) {
                sqlParas.add(param);
            }
        }
        if (app) {
            this.sql.append(" )");
        }
        return this;
    }


    //<editor-fold desc="id">
    public Where idEqual(Object value) {
        return idEqual(Logic.AND, value);
    }
    public Where idEqual(Logic logic, Object value) {
        return equal(logic, "id",value);
    }

    //</editor-fold>
    //<editor-fold desc="in">
    public Where in(String columnName, Object... values) {
        return in(Logic.AND,columnName, values);
    }

    public Where in(Logic logic, String columnName, Object... values) {
        if(values==null || values.length==0){
            throw new IllegalQueryException("values is zero or null");
        }
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        sql.append(" in (");
        StringBuilder ins=new StringBuilder();
        for (Object value : values) {
            if(ins.length()>0){
                ins.append(",");
            }
            ins.append("?");
        }
        sql.append(ins.toString());
        sql.append(" )");
        return w(logic, sql.toString(),values);
    }



    //</editor-fold>
    //<editor-fold desc="in">
    public Where notin(Logic logic, String columnName, Object... values) {
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        sql.append(" not in (");
        StringBuilder ins=new StringBuilder();
        for (Object value : values) {
            if(ins.length()>0){
                ins.append(",");
            }
            ins.append("?");
        }
        sql.append(ins.toString());
        sql.append(" )");
        return w(logic, sql.toString(),values);
    }

    public Where notin(String columnName, Object... values) {
        return notin(Logic.AND,columnName, values);
    }

    //</editor-fold>
    //<editor-fold desc="like">
    public Where like(Logic logic, String columnName, String keyword) {
        return like(logic,columnName, keyword,true);
    }

    public Where like(String columnName, String keyword) {
        return like(Logic.AND,columnName, keyword);
    }

    public Where like(Logic logic, String columnName, String keyword, boolean after) {
        return like(logic,columnName, keyword,false,after);
    }

    public Where like(String columnName, String keyword, boolean after) {
        return like(Logic.AND,columnName, keyword,after);
    }

    public Where like(String columnName, String keyword, boolean before, boolean after) {
        return like(Logic.AND,columnName, keyword,before,after);
    }

    public Where like(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        sql.append(" LIKE ?");
        StringBuilder value=new StringBuilder();
        if(after){
            value.append("%");
        }
        value.append(keyword);
        if(before){
            value.append("%");
        }
        return w(logic, sql.toString(),value.toString());
    }

    //</editor-fold>
    //<editor-fold desc="lessthan">

    public Where lessThan(String columnName, Object value) {
        return lessThan(Logic.AND, columnName,value);
    }

    public Where lessThan(Logic logic, String columnName, Object value) {
        return lessThan(logic, columnName, value, true);
    }

    public Where lessThan(String columnName, Object value, boolean equal) {
        return lessThan(Logic.AND, columnName,value,equal);
    }

    public Where lessThan(Logic logic, String columnName, Object value, boolean equal) {
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        if(equal){
            sql.append("<=");
        }else{
            sql.append("<");
        }
        sql.append("?");
        return w(logic, sql.toString(),value);
    }


    //</editor-fold>
    //<editor-fold desc="morethan">
    public Where moreThan(Logic logic, String columnName, Object value) {
        return moreThan(logic, columnName,value,true);
    }

    public Where moreThan(String columnName, Object value) {
        return moreThan(Logic.AND, columnName,value);
    }

    public Where moreThan(String columnName, Object value, boolean equal) {
        return moreThan(Logic.AND, columnName,value,equal);
    }
    public Where moreThan(Logic logic, String columnName, Object value, boolean equal) {
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        if(equal){
            sql.append(">=");
        }else{
            sql.append(">");
        }
        sql.append("?");
        return w(logic, sql.toString(),value);
    }


    //</editor-fold>
    //<editor-fold desc="notequal">

    public Where notEqual(String columnName, Object value) {
        return notEqual(Logic.AND,columnName,value);
    }

    public Where notEqual(Logic logic, String columnName, Object value) {
        String sql=""+columnName+"<>?";
        return w(logic, sql,value);
    }

    public <ENUM extends Enum> Where notEqual(String columnName, ENUM value, boolean ordinal) {
        return notEqual(Logic.AND,columnName,value,ordinal);
    }

    public <ENUM extends Enum> Where notEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        Object enumvalue=0;
        if(ordinal){
            enumvalue=value.ordinal();
        }else{
            enumvalue=value.name();
        }
        return notEqual(logic,columnName,enumvalue);
    }

    //</editor-fold>
    //<editor-fold desc="equal">
    public Where equal(String columnName, Object value) {
        return equal(Logic.AND,columnName,value);
    }

    public Where equal(Logic logic, String columnName, Object value) {
        String sql=""+columnName+"=?";
        return w(logic, sql,value);
    }

    public <ENUM extends Enum> Where equal(String columnName, ENUM value, boolean ordinal) {
        return equal(Logic.AND,columnName,value,ordinal);
    }

    public <ENUM extends Enum> Where equal(Logic logic, String columnName, ENUM value, boolean ordinal) {
        Object enumvalue=0;
        if(ordinal){
            enumvalue=value.ordinal();
        }else{
            enumvalue=value.name();
        }
        return equal(logic,columnName,enumvalue);
    }

    //</editor-fold>
    //<editor-fold desc="betweenthan">
    public Where betweenThan(String columnName, Object beginValue, Object endValue) {
        return betweenThan(Logic.AND, columnName,beginValue,endValue);
    }

    public Where betweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        return betweenThan(logic,columnName,beginValue,true,endValue,true);
    }
    public Where betweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        return betweenThan(Logic.AND, columnName,beginValue,beginEqual,endValue,endEqual);
    }

    public Where betweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        if(beginEqual){
            sql.append(">=");
        }else{
            sql.append(">");
        }
        sql.append("?");
        sql.append(" and ");
        sql.append(columnName);
        if(endEqual){
            sql.append("<=");
        }else{
            sql.append("<");
        }
        sql.append("?");
        return w(logic, sql.toString(),beginValue,endValue);
    }
    //</editor-fold>
    //<editor-fold desc="between">
    public Where between(String columnName, Object beginValue, Object endValue) {
        return between(Logic.AND, columnName,beginValue,endValue);
    }

    public Where between(Logic logic, String columnName, Object beginValue, Object endValue) {
        StringBuilder sql=new StringBuilder();
        sql.append(columnName);
        sql.append(" BETWEEN ?");
        sql.append(" and ");
        sql.append("?");
        return w(logic, sql.toString(),beginValue,endValue);
    }
    //</editor-fold>

    public int getPageNumber() {
        return pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public boolean isTotalRecord() {
        return totalRecord;
    }
}
